/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.DriveType;
import com.zebra.sdk.printer.StorageInfo;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.JacksonObjectMapperFactory;
import com.zebra.sdk.util.internal.PrinterFilePath;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZPLUtilities {
    public static final int ZPL_INTERNAL_FORMAT_PREFIX_CHAR = 30;
    public static final int ZPL_INTERNAL_COMMAND_PREFIX_CHAR = 16;
    public static final int ZPL_INTERNAL_DELIMITER_CHAR = 31;
    public static final String ZPL_INTERNAL_FORMAT_PREFIX = new String(new byte[]{30});
    public static final String ZPL_INTERNAL_COMMAND_PREFIX = new String(new byte[]{16});
    public static final String ZPL_INTERNAL_DELIMITER = new String(new byte[]{31});
    public static final String PRINTER_INFO = new String(new byte[]{16, 72, 73});
    public static final String PRINTER_STATUS = new String(new byte[]{16, 72, 83});
    public static final String PRINTER_CONFIG_LABEL = new String(new byte[]{16, 87, 67});
    public static final String PRINTER_DIRECTORY_LABEL = new String(new byte[]{30, 88, 65, 30, 87, 68, 42, 58, 42, 46, 42, 30, 88, 90});
    public static final String PRINTER_NETWORK_CONFIG_LABEL = new String(new byte[]{16, 87, 76});
    public static final String PRINTER_CALIBRATE = new String(new byte[]{16, 74, 67});
    public static final String PRINTER_RESET = new String(new byte[]{16, 74, 82});
    public static final String PRINTER_RESET_NETWORK = new String(new byte[]{16, 87, 82});
    public static final String PRINTER_RESTORE_DEFAULTS = new String(new byte[]{30, 88, 65, 30, 74, 85, 70, 30, 88, 90});
    public static final String PRINTER_GET_SUPER_HOST_STATUS = new String(new byte[]{30, 88, 65, 30, 72, 90, 65, 30, 88, 90});
    public static final String PRINTER_GET_STORAGE_INFO_COMMAND = new String(new byte[]{30, 88, 65, 30, 72, 87, 42, 58, 88, 88, 88, 88, 46, 81, 81, 81, 30, 88, 90});
    public static final String FILE_DRIVE_INFO_SETTING_NAME = "file.drive_info";
    public static final String FILE_DRIVE_LISTING_SETTING_NAME = "file.drive_listing";

    public static String decorateWithCommandPrefix(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("~") != -1) {
            return string.replace('~', '\u0010');
        }
        return ZPL_INTERNAL_COMMAND_PREFIX + string;
    }

    public static String decorateWithFormatPrefix(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("^") != -1) {
            return string.replace('^', '\u001e');
        }
        return ZPL_INTERNAL_FORMAT_PREFIX + string;
    }

    public static String replaceAllWithInternalDelimeter(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll(",", ZPL_INTERNAL_DELIMITER);
    }

    public static String replaceAllWithInternalCharacters(String string) {
        if (string == null) {
            return null;
        }
        return ZPLUtilities.replaceAllWithInternalDelimeter(string).replace("^", ZPL_INTERNAL_FORMAT_PREFIX).replace("~", ZPL_INTERNAL_COMMAND_PREFIX);
    }

    public static String replaceInternalCharactersWithReadableCharacters(String string) {
        return string.replaceAll(ZPL_INTERNAL_COMMAND_PREFIX, "~").replaceAll(ZPL_INTERNAL_FORMAT_PREFIX, "^").replaceAll(ZPL_INTERNAL_DELIMITER, ",");
    }

    public static byte[] replaceInternalCharactersWithReadableCharacters(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 16) {
                byArray[i] = 126;
                continue;
            }
            if (byArray[i] == 31) {
                byArray[i] = 44;
                continue;
            }
            if (byArray[i] != 30) continue;
            byArray[i] = 94;
        }
        return byArray;
    }

    public static void replaceInternalCharactersWithReadableCharacters(OutputStream outputStream, InputStream inputStream) throws ZebraIllegalArgumentException {
        ZPLUtilities zPLUtilities;
        ZPLUtilities zPLUtilities2 = zPLUtilities = new ZPLUtilities();
        zPLUtilities2.getClass();
        InternalCharacterFilteringOutputStream internalCharacterFilteringOutputStream = zPLUtilities2.new InternalCharacterFilteringOutputStream(outputStream);
        byte[] byArray = new byte[16384];
        try {
            try {
                int n;
                while ((n = inputStream.read(byArray)) != -1) {
                    internalCharacterFilteringOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                throw new ZebraIllegalArgumentException(iOException.getLocalizedMessage());
            }
            finally {
                internalCharacterFilteringOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new ZebraIllegalArgumentException(iOException.getLocalizedMessage());
        }
    }

    public static int getDpmm(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length >= 3) {
            try {
                return Integer.parseInt(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    public static List<StorageInfo> parseHWCommand(String string) {
        String[] stringArray;
        ArrayList<StorageInfo> arrayList = new ArrayList<StorageInfo>();
        Pattern pattern = Pattern.compile("(\\d+).+([A-Z]): ([\\w\\s]+)");
        for (String string2 : stringArray = string.split("\n")) {
            Matcher matcher = pattern.matcher(string2.trim());
            if (!matcher.find() || matcher.groupCount() != 3) continue;
            StorageInfo storageInfo = new StorageInfo();
            storageInfo.bytesFree = Long.parseLong(matcher.group(1));
            storageInfo.driveLetter = matcher.group(2).charAt(0);
            String string3 = matcher.group(3);
            storageInfo.driveType = DriveType.UNKNOWN;
            storageInfo.isPersistent = true;
            if (string3.equalsIgnoreCase("RAM")) {
                storageInfo.driveType = DriveType.RAM;
                storageInfo.isPersistent = false;
            } else if (string3.equalsIgnoreCase("OPTION MEMORY")) {
                storageInfo.driveType = DriveType.MASS_STORAGE;
                storageInfo.isPersistent = true;
            } else if (string3.equalsIgnoreCase("MEMORY CARD")) {
                storageInfo.driveType = DriveType.MASS_STORAGE;
                storageInfo.isPersistent = true;
            } else if (string3.equalsIgnoreCase("ONBOARD FLASH")) {
                storageInfo.driveType = DriveType.FLASH;
                storageInfo.isPersistent = true;
            }
            arrayList.add(storageInfo);
        }
        return arrayList;
    }

    public static List<StorageInfo> parseFileDriveInfoJson(String string) throws IOException {
        ArrayList<StorageInfo> arrayList = new ArrayList<StorageInfo>();
        ObjectMapper objectMapper = JacksonObjectMapperFactory.getInstance();
        MapType mapType = objectMapper.getTypeFactory().constructMapType(LinkedHashMap.class, String.class, FileObjectDetails.class);
        MapType mapType2 = objectMapper.getTypeFactory().constructMapType(LinkedHashMap.class, objectMapper.getTypeFactory().constructType(String.class), (JavaType)mapType);
        Map map = (Map)objectMapper.readValue(string, (JavaType)mapType2);
        Map map2 = (Map)map.get(FILE_DRIVE_INFO_SETTING_NAME);
        for (Map.Entry entry : map2.entrySet()) {
            StorageInfo storageInfo = new StorageInfo();
            storageInfo.driveLetter = ((String)entry.getKey()).charAt(0);
            storageInfo.bytesFree = ((FileObjectDetails)entry.getValue()).free;
            storageInfo.driveType = DriveType.UNKNOWN;
            storageInfo.isPersistent = true;
            String string2 = ((FileObjectDetails)entry.getValue()).storage;
            if (string2.equalsIgnoreCase("RAM")) {
                storageInfo.driveType = DriveType.RAM;
                storageInfo.isPersistent = false;
            } else if (string2.equalsIgnoreCase("READ ONLY")) {
                storageInfo.driveType = DriveType.READ_ONLY;
                storageInfo.isPersistent = true;
            } else if (string2.equalsIgnoreCase("ONBOARD FLASH")) {
                storageInfo.driveType = DriveType.FLASH;
                storageInfo.isPersistent = true;
            }
            arrayList.add(storageInfo);
        }
        return arrayList;
    }

    public static String[] filterFileList(String[] stringArray, String string) {
        Pattern pattern;
        Matcher matcher;
        if (string == null || string.equals("")) {
            string = "*:*.*";
        }
        if (!(matcher = (pattern = Pattern.compile("(([A-Za-z\\*]{1}):)?([A-Za-z0-9\\-_\\*]+)\\.([A-Za-z0-9\\-_\\*]+)")).matcher(string)).matches()) {
            return new String[0];
        }
        Pattern pattern2 = Pattern.compile(ZPLUtilities.createFileNameRegex(matcher));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            Matcher matcher2 = pattern2.matcher(string2);
            if (!matcher2.matches()) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    private static String createFileNameRegex(Matcher matcher) {
        String string = "([A-Za-z]{1}:)?";
        String string2 = "[A-Za-z0-9\\-_]*";
        String string3 = matcher.group(1);
        string3 = string3 == null ? string : string3.replaceAll("\\*:", string);
        String string4 = matcher.group(3).replaceAll("\\*", string2);
        String string5 = matcher.group(4).replaceAll("\\*", string2);
        return string3 + string4 + "\\." + string5;
    }

    public static String getHZO(String string) throws ZebraIllegalArgumentException {
        PrinterFilePath printerFilePath = FileUtilities.parseDriveAndExtension(string);
        String string2 = string.substring(string.lastIndexOf(46));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ZPL_INTERNAL_FORMAT_PREFIX);
        stringBuilder.append("XA");
        stringBuilder.append(ZPL_INTERNAL_FORMAT_PREFIX);
        stringBuilder.append("HZO");
        stringBuilder.append(ZPL_INTERNAL_DELIMITER);
        stringBuilder.append(printerFilePath.getDrive());
        stringBuilder.append(':');
        stringBuilder.append(printerFilePath.getFileName());
        stringBuilder.append(string2);
        stringBuilder.append(ZPL_INTERNAL_FORMAT_PREFIX);
        stringBuilder.append("XZ");
        return stringBuilder.toString();
    }

    public static String getDYPrefix(char c, String string, char c2, String string2, int n, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ZPL_INTERNAL_COMMAND_PREFIX).append("DY").append(c).append(':').append(string).append(ZPL_INTERNAL_DELIMITER).append(c2);
        stringBuilder.append(ZPL_INTERNAL_DELIMITER).append(string2).append(ZPL_INTERNAL_DELIMITER).append(String.valueOf(n)).append(ZPL_INTERNAL_DELIMITER).append(string3).append(ZPL_INTERNAL_DELIMITER);
        return stringBuilder.toString();
    }

    public static boolean isValidZplFirmware(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("[Vv][\\w-]+\\.[\\w-]+\\.[\\w-]+");
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    class InternalCharacterFilteringOutputStream
    extends FilterOutputStream {
        public InternalCharacterFilteringOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void write(int n) throws IOException {
            if (n == 16) {
                n = 126;
            } else if (n == 31) {
                n = 44;
            } else if (n == 30) {
                n = 94;
            }
            super.write(n);
        }
    }

    private static class FileObjectDetails {
        public String access;
        public String storage;
        public long size;
        public long free;
    }
}

