/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import com.zebra.sdk.printer.discovery.DiscoveredPrinterNetwork;
import com.zebra.sdk.printer.discovery.DiscoveryPacketDecodeException;
import com.zebra.sdk.printer.discovery.internal.PrinterPortStatus;
import com.zebra.sdk.util.internal.PacketParsingUtil;
import com.zebra.sdk.util.internal.StringUtilities;
import java.util.HashMap;

public class DiscoveryPacketDecoderLegacy {
    private static final int DISCOVERY_VERSION_OFFSET = 3;
    private static final int PRODUCT_NUMBER_OFFSET = 4;
    private static final int PRODUCT_NUMBER_SIZE = 8;
    private static final int PRODUCT_NAME_OFFSET = 12;
    private static final int PRODUCT_NAME_SIZE = 20;
    private static final int DATE_CODE_OFFSET = 32;
    private static final int DATE_CODE_SIZE = 7;
    private static final int FW_VERSION_OFFSET = 39;
    private static final int FW_VERSION_SIZE = 10;
    private static final int COMPANY_ABBREVIATION_OFFSET = 49;
    private static final int COMPANY_ABBREVIATION_SIZE = 5;
    private static final int HW_ADDRESS_OFFSET = 54;
    private static final int HW_ADDRESS_SIZE = 6;
    private static final int SERIAL_NUM_OFFSET = 60;
    private static final int SERIAL_NUM_SIZE = 10;
    private static final int USING_NET_PROTOCOL_OFFSET = 70;
    private static final int USING_NET_PROTOCOL_SIZE = 2;
    private static final int IP_ADDRESS_OFFSET = 72;
    private static final int IP_ADDRESS_SIZE = 4;
    private static final int SUBNET_MASK_OFFSET = 76;
    private static final int SUBNET_MASK_SIZE = 4;
    private static final int DEFAULT_GATEWAY_OFFSET = 80;
    private static final int DEFAULT_GATEWAY_SIZE = 4;
    private static final int SYSTEM_NAME_OFFSET = 84;
    private static final int SYSTEM_NAME_SIZE = 25;
    private static final int GET_COMMUNITY_NAME_OFFSET = 212;
    private static final int GET_COMMUNITY_NAME_SIZE = 32;
    private static final int SET_COMMUNITY_NAME_OFFSET = 244;
    private static final int SET_COMMUNITY_NAME_SIZE = 32;
    private static final int PORT_STATUS_OFFSET = 358;
    private static final int PORT_STATUS_SIZE = 1;
    private static final int PORT_NAME_OFFSET = 359;
    private static final int PORT_NAME_SIZE = 16;
    private static final int MIN_PACKET_SIZE = 375;
    private byte[] rawDiscoveryPacket = null;

    public DiscoveryPacketDecoderLegacy(byte[] byArray) {
        this.rawDiscoveryPacket = byArray;
    }

    public DiscoveredPrinterNetwork getDiscoveredPrinterNetwork() throws DiscoveryPacketDecodeException {
        if (this.rawDiscoveryPacket.length < 375) {
            throw new DiscoveryPacketDecodeException("Unable to parse the supplied discovery packet due to an invalid discovery packet length");
        }
        return new DiscoveredPrinterNetwork(this.getDiscoveryDataMap());
    }

    private HashMap<String, String> getDiscoveryDataMap() throws DiscoveryPacketDecodeException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("PORT_NUMBER", String.valueOf(this.getPrinterPort()));
        hashMap.put("DNS_NAME", this.getDnsName());
        hashMap.put("ADDRESS", this.getIpAddress());
        hashMap.put("COMPANY_ABBREVIATION", this.getCompanyAbbreviation());
        hashMap.put("DISCOVERY_VER", String.valueOf(this.getDiscoveryVersion()));
        hashMap.put("PRODUCT_NUMBER", this.getProductNumber());
        hashMap.put("PRODUCT_NAME", this.getProductName());
        hashMap.put("DATE_CODE", this.getDateCode());
        hashMap.put("FIRMWARE_VER", this.getFirmwareVersion());
        hashMap.put("HARDWARE_ADDRESS", this.getHardwareAddress());
        hashMap.put("SERIAL_NUMBER", this.getSerialNumber());
        hashMap.put("USING_NET_PROTOCOL", this.getUsingNetProtocol() ? "true" : "false");
        hashMap.put("SUBNET_MASK", this.getSubnetmask());
        hashMap.put("GATEWAY", this.getGateway());
        hashMap.put("SYSTEM_NAME", this.getSystemName());
        hashMap.put("PORT_NAME", this.getPortName());
        hashMap.put("PORT_STATUS", this.getPortStatus().toString());
        hashMap.put("ENCRYPTED_GET_COMMUNITY_NAME", this.getGetCommunityNameAsHexString());
        hashMap.put("ENCRYPTED_SET_COMMUNITY_NAME", this.getSetCommunityNameAsHexString());
        return hashMap;
    }

    private String getSetCommunityNameAsHexString() {
        byte[] byArray = this.copyOfRange(this.rawDiscoveryPacket, 244, 276);
        return StringUtilities.byteArrayToHexString(byArray);
    }

    private String getGetCommunityNameAsHexString() {
        byte[] byArray = this.copyOfRange(this.rawDiscoveryPacket, 212, 244);
        return StringUtilities.byteArrayToHexString(byArray);
    }

    private byte[] copyOfRange(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2 - n + 1];
        for (int i = n; i <= n2; ++i) {
            byArray2[i - n] = byArray[i];
        }
        return byArray2;
    }

    private String getCompanyAbbreviation() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 49, 5);
    }

    private boolean getUsingNetProtocol() {
        return PacketParsingUtil.parseBoolean(this.rawDiscoveryPacket, 70, 2);
    }

    private String getSystemName() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 84, 25);
    }

    private String getSubnetmask() {
        return PacketParsingUtil.parseAddress(this.rawDiscoveryPacket, 76, 4);
    }

    private String getSerialNumber() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 60, 10);
    }

    private String getProductNumber() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 4, 8);
    }

    private String getProductName() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 12, 20);
    }

    private PrinterPortStatus getPortStatus() {
        return DiscoveryPacketDecoderLegacy.parseStatus(this.rawDiscoveryPacket, 358, 1);
    }

    private String getPortName() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 359, 16);
    }

    private String getHardwareAddress() {
        return PacketParsingUtil.parseGeneralByte(this.rawDiscoveryPacket, 54, 6);
    }

    private String getGateway() {
        return PacketParsingUtil.parseAddress(this.rawDiscoveryPacket, 80, 4);
    }

    private String getFirmwareVersion() {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 39, 10);
    }

    private int getDiscoveryVersion() {
        return PacketParsingUtil.byte2int(this.rawDiscoveryPacket[3]);
    }

    private String getDateCode() throws DiscoveryPacketDecodeException {
        return PacketParsingUtil.parseGeneralString(this.rawDiscoveryPacket, 32, 7);
    }

    private int getPrinterPort() throws DiscoveryPacketDecodeException {
        String string = this.getProductName();
        int n = 9100;
        if (string.startsWith("QL") || string.startsWith("RW") || string.startsWith("MZ") || string.startsWith("P4T") || string.startsWith("MQ") || string.startsWith("MU")) {
            n = 6101;
        }
        return n;
    }

    private String getIpAddress() throws DiscoveryPacketDecodeException {
        return PacketParsingUtil.parseAddress(this.rawDiscoveryPacket, 72, 4);
    }

    private String getDnsName() throws DiscoveryPacketDecodeException {
        return this.getSystemName();
    }

    private static PrinterPortStatus parseStatus(byte[] byArray, int n, int n2) {
        int n3 = PacketParsingUtil.byte2int(byArray[n]);
        return PrinterPortStatus.intToEnum(n3);
    }
}

