/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.reedsolomon;

public final class BCH_15_5 {
    private static final int GX = 311;
    private static final BCH_15_5 instance = new BCH_15_5();
    private int[] trueCodes = new int[32];

    private BCH_15_5() {
        this.makeTrueCodes();
    }

    public static BCH_15_5 getInstance() {
        return instance;
    }

    private void makeTrueCodes() {
        int i = 0;
        while (i < this.trueCodes.length) {
            this.trueCodes[i] = this.slowEncode(i);
            ++i;
        }
    }

    private int slowEncode(int data) {
        int wk = 0;
        data <<= 5;
        int i = 0;
        while (i < 5) {
            if ((((wk <<= 1) ^ (data <<= 1)) & 0x400) != 0) {
                wk ^= 0x137;
            }
            ++i;
        }
        return data & 0x7C00 | wk & 0x3FF;
    }

    public int encode(int data) {
        return this.trueCodes[data & 0x1F];
    }

    private static int calcDistance(int c1, int c2) {
        int n = 0;
        int wk = c1 ^ c2;
        while (wk != 0) {
            if ((wk & 1) != 0) {
                ++n;
            }
            wk >>= 1;
        }
        return n;
    }

    public int decode(int data) {
        data &= Short.MAX_VALUE;
        int i = 0;
        while (i < this.trueCodes.length) {
            int code = this.trueCodes[i];
            if (BCH_15_5.calcDistance(data, code) <= 3) {
                return code;
            }
            ++i;
        }
        return -1;
    }
}

