/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.weblink;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.NotALinkOsPrinterException;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.PrinterReconnectionHandler;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.settings.SettingsValues;
import com.zebra.sdk.util.internal.Sleeper;
import com.zebra.sdk.weblink.ConfigurationStatus;
import com.zebra.sdk.weblink.WeblinkAddressStrategy;
import com.zebra.sdk.weblink.WeblinkConfigurationState;
import com.zebra.sdk.weblink.WeblinkConfigurationStateUpdater;
import com.zebra.sdk.weblink.ZebraWeblinkException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.UrlValidator;

public class WeblinkConfigurator {
    Connection connection = null;
    WeblinkConfigurationState myState;
    ConfigurationStatus myStatus;
    private ConnectionReestablisher reestablisher;
    private PrinterLanguage printerLanguage = null;
    private LinkOsInformation linkOsVersion = null;
    private WeblinkLocationToSet weblinkLocationToSet;

    public WeblinkConfigurator(DiscoveredPrinter discoveredPrinter) {
        this(discoveredPrinter.getConnection());
    }

    public WeblinkConfigurator(Connection connection) {
        this.connection = connection;
        this.myState = WeblinkConfigurationState.ConnectToPrinter;
        this.myStatus = ConfigurationStatus.NOT_STARTED;
    }

    public void configure(String string, WeblinkAddressStrategy weblinkAddressStrategy, WeblinkConfigurationStateUpdater weblinkConfigurationStateUpdater) throws ZebraWeblinkException {
        this.myStatus = ConfigurationStatus.IN_PROCESS;
        this.updateState(weblinkConfigurationStateUpdater, WeblinkConfigurationState.ConnectToPrinter);
        if (string != null && !string.isEmpty() && this.isValidWeblinkUrl(string)) {
            ConfigurationStatus configurationStatus = this.myStatus;
            try {
                this.connectToPrinter();
                this.reestablisher = this.connection.getConnectionReestablisher(240000L);
                this.updateState(weblinkConfigurationStateUpdater, WeblinkConfigurationState.GetSettings);
                Map<String, String> map = this.getSettings();
                Map<String, String> map2 = this.getSettingsToConfigure(string, weblinkAddressStrategy, weblinkConfigurationStateUpdater, map);
                if (map2.size() > 0) {
                    new SettingsValues().setValues(map2, this.connection, this.printerLanguage, this.linkOsVersion);
                    Sleeper.sleep(1000L);
                    this.restartPrinter(weblinkConfigurationStateUpdater);
                    this.reconnectToPrinter(weblinkConfigurationStateUpdater);
                }
                this.verifyPrinterNumConnections(map2, map, weblinkConfigurationStateUpdater);
                configurationStatus = ConfigurationStatus.SUCCESSFULLY_COMPLETED;
            }
            catch (ZebraWeblinkException zebraWeblinkException) {
                configurationStatus = ConfigurationStatus.CONFIGURATION_FAILED;
                throw zebraWeblinkException;
            }
            catch (Exception exception) {
                configurationStatus = ConfigurationStatus.CONFIGURATION_FAILED;
                throw new ZebraWeblinkException(exception);
            }
            finally {
                if (this.connection != null) {
                    try {
                        this.connection.close();
                    }
                    catch (ConnectionException connectionException) {}
                }
                this.myStatus = configurationStatus;
                this.updateState(weblinkConfigurationStateUpdater, this.myState);
            }
        }
        this.myStatus = ConfigurationStatus.CONFIGURATION_FAILED;
        this.updateState(weblinkConfigurationStateUpdater, this.myState);
        throw new ZebraWeblinkException("Invalid weblink address.");
    }

    private void verifyPrinterNumConnections(Map<String, String> map, Map<String, String> map2, WeblinkConfigurationStateUpdater weblinkConfigurationStateUpdater) throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraWeblinkException, NotALinkOsPrinterException {
        this.updateState(weblinkConfigurationStateUpdater, WeblinkConfigurationState.VerifyWeblinkConnection);
        boolean bl = false;
        LinkOsInformation linkOsInformation = new LinkOsInformation(map2.get("appl.link_os_version"));
        if (linkOsInformation.getMajor() >= 2) {
            try {
                int n;
                if (this.weblinkLocationToSet == WeblinkLocationToSet.SET_LOCATION_1 ? (n = Integer.parseInt(map2.get("weblink.ip.conn1.num_connections"))) > 0 : this.weblinkLocationToSet == WeblinkLocationToSet.SET_LOCATION_2 && (n = Integer.parseInt(map2.get("weblink.ip.conn2.num_connections"))) > 0) {
                    return;
                }
                Map<String, String> map3 = this.getSettings();
                bl = this.isConnected(map3);
                for (n = 0; !bl && n < 5; ++n) {
                    Sleeper.sleep(2000L);
                    map3 = this.getSettings();
                    bl = this.isConnected(map3);
                }
            }
            catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
                throw new ZebraWeblinkException(zebraIllegalArgumentException);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!bl) {
            throw new ZebraWeblinkException("Could not verify the connection to the Zebra Weblink server. You may need to review the printer weblink logs and/or the server logs if there are any connection issues.");
        }
    }

    private boolean isConnected(Map<String, String> map) throws ZebraWeblinkException {
        int n = -1;
        switch (this.weblinkLocationToSet) {
            case SET_LOCATION_1: {
                n = Integer.parseInt(map.get("weblink.ip.conn1.num_connections"));
                break;
            }
            case SET_LOCATION_2: {
                n = Integer.parseInt(map.get("weblink.ip.conn2.num_connections"));
                break;
            }
        }
        return n > 0;
    }

    private void reconnectToPrinter(WeblinkConfigurationStateUpdater weblinkConfigurationStateUpdater) throws DiscoveryException, ConnectionException, TimeoutException, ZebraPrinterLanguageUnknownException {
        this.updateState(weblinkConfigurationStateUpdater, WeblinkConfigurationState.ReconnectToPrinter);
        Sleeper.sleep(30000L);
        this.reestablisher.reestablishConnection(new PrinterReconnectionHandler(){

            @Override
            public void printerOnline(ZebraPrinterLinkOs zebraPrinterLinkOs, String string) {
                WeblinkConfigurator.this.connection = zebraPrinterLinkOs.getConnection();
            }
        });
    }

    private void restartPrinter(WeblinkConfigurationStateUpdater weblinkConfigurationStateUpdater) throws ConnectionException {
        this.updateState(weblinkConfigurationStateUpdater, WeblinkConfigurationState.RestartPrinter);
        SGD.SET("device.reset", "", this.connection);
        this.connection.close();
    }

    private Map<String, String> getSettingsToConfigure(String string, WeblinkAddressStrategy weblinkAddressStrategy, WeblinkConfigurationStateUpdater weblinkConfigurationStateUpdater, Map<String, String> map) throws ZebraWeblinkException {
        this.updateState(weblinkConfigurationStateUpdater, WeblinkConfigurationState.ConfigureWeblink);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (this.rtcTooOld(map)) {
            linkedHashMap.put("rtc.date", "01-01-2013");
        }
        String string2 = "";
        if (map.containsKey("weblink.ip.conn1.location")) {
            string2 = map.get("weblink.ip.conn1.location");
            if (string2 == null) {
                try {
                    SGD.SET("device.reset", "", this.connection);
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
                throw new ZebraWeblinkException("Weblink settings unavailable. Rebooting printer. Please try again.");
            }
        } else {
            throw new ZebraWeblinkException("Weblink settings not retrieved");
        }
        boolean bl = this.checkConnection("weblink.ip.conn1.num_connections", map);
        String string3 = "";
        if (!map.containsKey("weblink.ip.conn2.location")) {
            throw new ZebraWeblinkException("Weblink settings not retrieved");
        }
        string3 = map.get("weblink.ip.conn2.location");
        boolean bl2 = this.checkConnection("weblink.ip.conn2.num_connections", map);
        if (string2.equalsIgnoreCase(string) && string3.equalsIgnoreCase(string)) {
            if (weblinkAddressStrategy == WeblinkAddressStrategy.FORCE_CONNECTION_1) {
                weblinkConfigurationStateUpdater.progressUpdate("Both weblink locations set to " + string + ", clearing location 2");
                linkedHashMap.put("weblink.ip.conn2.location", "");
                this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_1;
            } else {
                weblinkConfigurationStateUpdater.progressUpdate("Both weblink locations set to " + string + ", clearing location 1");
                linkedHashMap.put("weblink.ip.conn1.location", "");
                this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_2;
            }
        } else if (string2.equalsIgnoreCase(string)) {
            if (weblinkAddressStrategy == WeblinkAddressStrategy.FORCE_CONNECTION_2) {
                weblinkConfigurationStateUpdater.progressUpdate("Weblink location 1 already set to " + string + ", configuring for location 2");
                linkedHashMap.put("weblink.ip.conn2.location", string);
                linkedHashMap.put("weblink.ip.conn1.location", "");
                this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_2;
            } else if (bl) {
                weblinkConfigurationStateUpdater.progressUpdate("Weblink location 1 already connected to " + string);
                this.updateState(weblinkConfigurationStateUpdater, WeblinkConfigurationState.RestartPrinter);
                this.updateState(weblinkConfigurationStateUpdater, WeblinkConfigurationState.ReconnectToPrinter);
                this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_1;
            } else {
                weblinkConfigurationStateUpdater.progressUpdate("Weblink location 1 already set to " + string);
                this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_1;
            }
        } else if (string3.equalsIgnoreCase(string)) {
            if (weblinkAddressStrategy == WeblinkAddressStrategy.FORCE_CONNECTION_1) {
                weblinkConfigurationStateUpdater.progressUpdate("Weblink location 2 already set to " + string + ", configuring for location 1");
                linkedHashMap.put("weblink.ip.conn1.location", string);
                linkedHashMap.put("weblink.ip.conn2.location", "");
                this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_1;
            } else if (bl2) {
                weblinkConfigurationStateUpdater.progressUpdate("Weblink location 2 already connected to " + string);
                this.updateState(weblinkConfigurationStateUpdater, WeblinkConfigurationState.RestartPrinter);
                this.updateState(weblinkConfigurationStateUpdater, WeblinkConfigurationState.ReconnectToPrinter);
                this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_2;
            } else {
                weblinkConfigurationStateUpdater.progressUpdate("Weblink location 2 already set to " + string);
                this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_2;
            }
        } else {
            switch (weblinkAddressStrategy) {
                case AUTO_SELECT: {
                    if (string3.isEmpty() || !this.isValidWeblinkUrl(string3)) {
                        linkedHashMap.put("weblink.ip.conn2.location", string);
                        this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_2;
                        break;
                    }
                    if (string2.isEmpty() || !this.isValidWeblinkUrl(string2)) {
                        linkedHashMap.put("weblink.ip.conn1.location", string);
                        this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_1;
                        break;
                    }
                    if (!bl2) {
                        linkedHashMap.put("weblink.ip.conn2.location", string);
                        this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_2;
                        break;
                    }
                    if (!bl) {
                        linkedHashMap.put("weblink.ip.conn1.location", string);
                        this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_1;
                        break;
                    }
                    linkedHashMap.put("weblink.ip.conn2.location", string);
                    this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_2;
                    break;
                }
                case FORCE_CONNECTION_1: {
                    linkedHashMap.put("weblink.ip.conn1.location", string);
                    this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_1;
                    break;
                }
                case FORCE_CONNECTION_2: {
                    linkedHashMap.put("weblink.ip.conn2.location", string);
                    this.weblinkLocationToSet = WeblinkLocationToSet.SET_LOCATION_2;
                }
            }
            String string4 = this.weblinkLocationToSet == WeblinkLocationToSet.SET_LOCATION_1 ? "1" : "2";
            weblinkConfigurationStateUpdater.progressUpdate("Setting weblink location " + string4 + " to " + string);
        }
        return linkedHashMap;
    }

    private boolean rtcTooOld(Map<String, String> map) {
        String string = map.get("rtc.date");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy");
        try {
            Date date = simpleDateFormat.parse(string);
            Date date2 = simpleDateFormat.parse("01-01-2013");
            if (date.before(date2)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Map<String, String> getSettings() throws ConnectionException, ZebraPrinterLanguageUnknownException, ZebraIllegalArgumentException, NotALinkOsPrinterException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("rtc.date");
        arrayList.add("weblink.ip.conn1.location");
        arrayList.add("weblink.ip.conn2.location");
        arrayList.add("weblink.ip.conn1.num_connections");
        arrayList.add("weblink.ip.conn2.num_connections");
        arrayList.add("appl.link_os_version");
        this.printerLanguage = this.getPrinterLanguage();
        this.linkOsVersion = this.getLinkOsVersionInfo();
        return new SettingsValues().getValues(arrayList, this.connection, this.printerLanguage, this.linkOsVersion);
    }

    private void connectToPrinter() throws ConnectionException {
        this.connection.open();
    }

    private void updateState(WeblinkConfigurationStateUpdater weblinkConfigurationStateUpdater, WeblinkConfigurationState weblinkConfigurationState) {
        weblinkConfigurationStateUpdater.updateState(weblinkConfigurationState);
        this.myState = weblinkConfigurationState;
    }

    private boolean checkConnection(String string, Map<String, String> map) {
        String string2 = map.get(string);
        return string2 != null && !string2.equals("0");
    }

    public WeblinkConfigurationState getCurrentState() {
        return this.myState;
    }

    public ConfigurationStatus getStatus() {
        return this.myStatus;
    }

    public boolean isValidWeblinkUrl(String string) {
        UrlValidator urlValidator = new UrlValidator(new String[]{"https"}, new RegexValidator("^((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{1,63}(:\\d+)?$"), 8L);
        return urlValidator.isValid(string);
    }

    private PrinterLanguage getPrinterLanguage() throws ConnectionException, NotALinkOsPrinterException, ZebraPrinterLanguageUnknownException {
        if (this.printerLanguage == null) {
            String string = SGD.GET("device.languages", this.connection);
            if (string.equals("?")) {
                throw new NotALinkOsPrinterException();
            }
            this.printerLanguage = PrinterLanguage.getLanguage(string);
        }
        return this.printerLanguage;
    }

    private LinkOsInformation getLinkOsVersionInfo() throws ConnectionException, NotALinkOsPrinterException {
        if (this.linkOsVersion == null) {
            String string = SGD.GET("appl.link_os_version", this.connection);
            if (string.equals("?")) {
                throw new NotALinkOsPrinterException();
            }
            this.linkOsVersion = new LinkOsInformation(string);
        }
        return this.linkOsVersion;
    }

    static enum WeblinkLocationToSet {
        SET_LOCATION_1,
        SET_LOCATION_2;

    }
}

