/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import com.zebra.sdk.device.ZebraIllegalArgumentException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtil {
    private static final int DOCUMENT_NODE_TYPE = 9;
    private static final int TEXT_NODE_TYPE = 3;

    public static void getAllSubNodesByName(List<Node> list, Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals(string)) {
                list.add(node2);
            }
            XmlUtil.getAllSubNodesByName(list, node2, string);
        }
    }

    public static Node getFirstSubNodeByName(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals(string)) {
                return node2;
            }
            Node node3 = XmlUtil.getFirstSubNodeByName(node2, string);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    public static String getTextContent(Node node, String string) {
        Node node2;
        if (node != null && (node2 = node.getFirstChild()) != null) {
            String string2 = node2.getNodeValue();
            Node node3 = node2.getNextSibling();
            if (node3 != null) {
                string2 = node3.getNodeValue();
            }
            if (string2 != null) {
                return string2;
            }
        }
        return string;
    }

    public static List<Node> getAllNodesByPath(Document document, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split("/");
        NodeList nodeList = document.getElementsByTagName(stringArray[stringArray.length - 1]);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            int n;
            Node node = nodeList.item(i);
            for (n = stringArray.length - 1; n >= 0 && node.getNodeName().equals(stringArray[n]); --n) {
                node = node.getParentNode();
            }
            if (n != -1) continue;
            arrayList.add(nodeList.item(i));
        }
        return arrayList;
    }

    public static List<Node> findImmediateChildByName(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (node == null || string == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(string)) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    public static Node getFirstNodeByPath(Document document, String string) {
        List<Node> list = XmlUtil.getAllNodesByPath(document, string);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static Node getDataAtNamedNode(ByteArrayInputStream byteArrayInputStream, String string, String string2) throws SAXException, IOException, ParserConfigurationException, ZebraIllegalArgumentException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(byteArrayInputStream);
        NodeList nodeList = document.getChildNodes();
        Node node = XmlUtil.getFirstSubNodeByName(nodeList.item(0), string);
        if (node == null) {
            String string3 = "Malformed response from printer";
            if (string2 != null && string2.length() > 0) {
                string3 = string3 + " for " + string2;
            }
            string3 = string3 + ".";
            throw new ZebraIllegalArgumentException(string3);
        }
        return node;
    }

    public static Node getDataAtNamedNode(ByteArrayInputStream byteArrayInputStream, String string) throws SAXException, IOException, ParserConfigurationException, ZebraIllegalArgumentException {
        return XmlUtil.getDataAtNamedNode(byteArrayInputStream, string, null);
    }

    public static String xmlToString(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        if (node != null) {
            if (node.getNodeType() == 3) {
                stringBuilder.append(node.getNodeValue());
            } else {
                if (node.getNodeType() != 9) {
                    stringBuilder.append("<").append(node.getNodeName()).append(">");
                    if (node.hasChildNodes() && node.getFirstChild().getNodeType() != 3) {
                        stringBuilder.append("\r\n");
                    }
                } else {
                    stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
                }
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    stringBuilder.append(XmlUtil.xmlToString(node2));
                }
                if (node.getNodeType() != 9) {
                    stringBuilder.append("</").append(node.getNodeName()).append(">\r\n");
                }
            }
        }
        return stringBuilder.toString();
    }
}

