/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.util.internal.JacksonObjectMapperFactory;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StringUtilities {
    public static final String CRLF = "\r\n";
    public static final String LF = "\n";

    public static int indexOf(String string, String[] stringArray, int n) {
        int n2 = string.length();
        for (int i = 0; i < stringArray.length; ++i) {
            int n3 = string.indexOf(stringArray[i], n);
            if (n3 < 0 || n3 >= n2) continue;
            n2 = n3;
        }
        if (n2 == string.length()) {
            n2 = -1;
        }
        return n2;
    }

    public static String[] split(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        while (n2 >= 0) {
            n2 = string.indexOf(string2, n);
            if (n2 >= 0) {
                String string3 = string.substring(n, n2);
                arrayList.add(string3);
                n = n2 + string2.length();
                continue;
            }
            if (n > string.length() - 1) continue;
            arrayList.add(string.substring(n));
        }
        return arrayList.toArray(new String[0]);
    }

    public static String join(String[] stringArray, String string) {
        String string2 = "";
        if (stringArray == null || string == null) {
            return "";
        }
        for (String string3 : stringArray) {
            string2 = string2 + string3 + string;
        }
        if (!string2.equals("")) {
            string2 = string2.substring(0, string2.length() - string.length());
        }
        return string2;
    }

    public static int countSubstringOccurences(String string, String string2) {
        int n = 0;
        int n2 = 0;
        while (n >= 0) {
            if ((n = string.indexOf(string2, n)) < 0) continue;
            ++n2;
            n += string2.length();
        }
        return n2;
    }

    public static String stripQuotes(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl;
            char c = string.charAt(i);
            boolean bl2 = bl = c != '\"';
            if (!bl) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String padWithChar(String string, char c, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            if (bl) {
                stringBuffer.insert(0, c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static boolean doesPrefixExistInArray(String[] stringArray, String string) {
        if (string == null || stringArray == null || string.length() == 0 || stringArray.length == 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() == 0 || !string.toUpperCase().startsWith(stringArray[i].toUpperCase())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            int n = (by & 0xFF) >> 4;
            int n2 = by & 0xF;
            string = string + Integer.toString(n, 16);
            string = string + Integer.toString(n2, 16);
        }
        return string;
    }

    public static byte[] hexToByteArray(String string) throws ZebraIllegalArgumentException {
        int n = string.length();
        if (n % 2 != 0) {
            throw new ZebraIllegalArgumentException("Hex string must have an even number of digits");
        }
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byte by;
            int n2 = Character.digit(string.charAt(i), 16);
            int n3 = Character.digit(string.charAt(i + 1), 16);
            if (n2 == -1 || n3 == -1) {
                throw new ZebraIllegalArgumentException("Input contains data that is not a hex digit");
            }
            int n4 = (n2 << 4) + n3;
            byArray[i / 2] = by = (byte)n4;
        }
        return byArray;
    }

    public static List<String> toList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public static List<String> toList(String[][] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[][] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray3;
            for (String string : stringArray3 = stringArray2[i]) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static String stringPadToPlaces(int n, String string, String string2, boolean bl) {
        if (string2.length() >= n) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n - string2.length(); ++i) {
            stringBuilder.append(string);
        }
        if (bl) {
            stringBuilder = stringBuilder.insert(0, string2, 0, string2.length());
        } else {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String stringPadToPlaces(int n, char c, String string, boolean bl) {
        if (string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuilder.append(c);
        }
        if (bl) {
            stringBuilder = stringBuilder.insert(0, string, 0, string.length());
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static byte[] byteArrayPadToPlaces(int n, byte[] byArray) {
        if (byArray.length >= n) {
            return byArray;
        }
        int n2 = n - byArray.length;
        byte[] byArray2 = new byte[n];
        int n3 = 0;
        for (int i = n2; i < n; ++i) {
            byArray2[i] = byArray[n3++];
        }
        return byArray2;
    }

    public static String convertTo8dot3(String string) {
        return StringUtilities.convertToXdot3(string, 8);
    }

    public static String convertTo16dot3(String string) {
        return StringUtilities.convertToXdot3(string, 16);
    }

    private static String convertToXdot3(String string, int n) {
        int n2 = string.lastIndexOf(46);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (n2 != -1) {
            int n3 = n2 > n ? n : n2;
            string2 = string.substring(0, n3);
            string3 = string.substring(n2);
            if (string3.length() > 4) {
                string3 = string3.substring(0, 4);
            }
            string4 = string2 + string3;
        } else {
            int n4 = string.length() < n ? string.length() : n;
            string4 = string.substring(0, n4);
        }
        return string4;
    }

    public static String stringPadToPlaces(int n, String string, String string2) {
        if (string2.length() >= n) {
            return string2;
        }
        String string3 = "";
        for (int i = 0; i < n - string2.length(); ++i) {
            string3 = string3 + string;
        }
        string3 = string3 + string2;
        return string3;
    }

    public static long stringToLong(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            try {
                char c = string.charAt(i);
                Integer.parseInt("" + c);
                stringBuilder.append(c);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
        }
        return Long.parseLong(stringBuilder.toString());
    }

    public static Map<String, String> convertKeyValueJsonToMap(byte[] byArray) throws IOException {
        return StringUtilities.convertKeyValueJsonToMap(new String(byArray, "utf-8"));
    }

    public static Map<String, String> convertKeyValueJsonToMap(String string) throws IOException {
        MapType mapType = TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, Object.class);
        ObjectMapper objectMapper = JacksonObjectMapperFactory.getInstance();
        Map map = (Map)objectMapper.readValue(string, (JavaType)mapType);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : map.keySet()) {
            Object v = map.get(string2);
            if (v instanceof Map) {
                ObjectMapper objectMapper2 = new ObjectMapper();
                hashMap.put(string2, objectMapper2.writeValueAsString(v));
                continue;
            }
            if (v instanceof String) {
                hashMap.put(string2, (String)v);
                continue;
            }
            if (v != null) continue;
            hashMap.put(string2, null);
        }
        return hashMap;
    }

    public static String repeat(String string, int n) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String getStringValueForKey(Map<String, String> map, String string) {
        String string2 = map.get(string);
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        throw new IllegalArgumentException();
    }

    public static int getIntValueForKey(Map<String, String> map, String string) {
        return Integer.parseInt(StringUtilities.getStringValueForKey(map, string));
    }

    public static double convertStringToDouble(String string) throws ZebraIllegalArgumentException {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                NumberFormat numberFormat = NumberFormat.getInstance();
                Number number = numberFormat.parse(string);
                return number.doubleValue();
            }
            catch (ParseException parseException) {
                throw new ZebraIllegalArgumentException(numberFormatException.getLocalizedMessage());
            }
        }
    }

    public static String convertDoubleToString(double d) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        return numberFormat.format(d);
    }
}

