/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.fileConversion.internal;

import com.zebra.sdk.util.fileConversion.internal.CisdfUnwrapperStream;
import com.zebra.sdk.util.fileConversion.internal.DG_ToDyConverterStream;
import com.zebra.sdk.util.fileConversion.internal.DY_UnwrapperStream;
import com.zebra.sdk.util.fileConversion.internal.DZ_UnwrapperStream;
import com.zebra.sdk.util.fileConversion.internal.HzoToDzConverterStream;
import com.zebra.sdk.util.fileConversion.internal.MPF_UnwrapperStream;
import com.zebra.sdk.util.fileConversion.internal.MetadataExtractorPassthruStream;
import com.zebra.sdk.util.fileConversion.internal.PrinterWrappingType;
import com.zebra.sdk.util.fileConversion.internal.StreamDecoratorBase;
import com.zebra.sdk.util.internal.PrinterFileMetadata;
import java.io.IOException;
import java.io.InputStream;

public class PrinterFileUnwrapperStream
extends StreamDecoratorBase {
    private StreamDecoratorBase baseStream;
    private PrinterWrappingType fileType;

    public PrinterFileUnwrapperStream(InputStream inputStream, PrinterWrappingType printerWrappingType) throws IOException {
        this.fileType = printerWrappingType;
        if (inputStream == null) {
            throw new IOException("Input stream is null");
        }
        switch (printerWrappingType) {
            case DY: {
                this.baseStream = new DY_UnwrapperStream(inputStream);
                break;
            }
            case DZ: {
                this.baseStream = new DZ_UnwrapperStream(inputStream);
                break;
            }
            case DG: {
                this.baseStream = new DY_UnwrapperStream(new DG_ToDyConverterStream(inputStream));
                break;
            }
            case CISDF: {
                this.baseStream = new CisdfUnwrapperStream(inputStream);
                break;
            }
            case HZO: {
                this.baseStream = new DZ_UnwrapperStream(new HzoToDzConverterStream(inputStream));
                break;
            }
            case MPF: {
                this.baseStream = new MPF_UnwrapperStream(inputStream);
                break;
            }
            default: {
                this.baseStream = new MetadataExtractorPassthruStream(inputStream);
            }
        }
    }

    @Override
    public int read() throws IOException {
        return this.baseStream.read();
    }

    @Override
    public PrinterFileMetadata getPrinterFileMetadata() {
        PrinterFileMetadata printerFileMetadata = this.baseStream.getPrinterFileMetadata();
        printerFileMetadata.setPrinterWrappingType(this.fileType);
        return printerFileMetadata;
    }
}

