/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.fileConversion.internal;

import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.util.fileConversion.internal.PrinterFileType;
import com.zebra.sdk.util.fileConversion.internal.PrinterWrappingType;
import com.zebra.sdk.util.fileConversion.internal.StreamDecoratorBase;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.PrinterFileMetadata;
import com.zebra.sdk.util.internal.PrinterFilePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class CisdfUnwrapperStream
extends StreamDecoratorBase {
    private PrinterFileMetadata printerFileMetadata;
    private long bytesLeftToRead;
    private PushbackInputStream sourceStream;

    public CisdfUnwrapperStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Missing CISDF Header : input stream is null");
        }
        this.sourceStream = new PushbackInputStream(inputStream);
        this.skipToHeaderInfo();
        String string = this.grabNextCisdfLine();
        String string2 = this.grabNextCisdfLine();
        String string3 = this.grabNextCisdfLine();
        int n = Integer.parseInt(string3, 16);
        String string4 = this.grabNextCisdfLine();
        this.printerFileMetadata = new PrinterFileMetadata(n, string, string4, string2);
        this.printerFileMetadata.setPrinterFileType(this.getFileType(string2));
        this.printerFileMetadata.setPrinterWrappingType(PrinterWrappingType.CISDF);
        this.bytesLeftToRead = n;
    }

    private PrinterFileType getFileType(String string) {
        PrinterFileType printerFileType = PrinterFileType.UNSUPPORTED;
        try {
            PrinterFilePath printerFilePath = FileUtilities.parseDriveAndExtension(string);
            printerFileType = PrinterFileType.getUnwrappedType(printerFilePath.getExtension());
        }
        catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
            printerFileType = PrinterFileType.UNSUPPORTED;
        }
        return printerFileType;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesLeftToRead > 0L) {
            int n = this.sourceStream.read();
            if (n < 0) {
                throw new IOException("Expected more data");
            }
            --this.bytesLeftToRead;
            return n;
        }
        return -1;
    }

    private void skipToHeaderInfo() throws IOException {
        String string = this.grabNextCisdfLine();
        while (string.isEmpty()) {
            string = this.grabNextCisdfLine();
        }
        if (!string.startsWith("! CISDFCRC16") && !string.startsWith("! CISDFRCRC16")) {
            throw new IOException("Invalid CISDF Header : \"" + string + "\" does not start with \"" + "! CISDFCRC16" + "\" or \"" + "! CISDFRCRC16" + "\".");
        }
    }

    private String grabNextCisdfLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.sourceStream.read();
        while (n != -1 && Character.isWhitespace(n)) {
            n = this.sourceStream.read();
        }
        while (n != -1 && !this.isEndOfLineCharacter(n)) {
            stringBuilder.append((char)n);
            n = this.sourceStream.read();
        }
        n = this.sourceStream.read();
        if (!this.isEndOfLineCharacter(n)) {
            this.sourceStream.unread(n);
        }
        if (stringBuilder.length() == 0) {
            throw new IOException("Invalid CISDF Header");
        }
        return stringBuilder.toString().trim();
    }

    private boolean isEndOfLineCharacter(int n) {
        return n == 10 || n == 13;
    }

    @Override
    public PrinterFileMetadata getPrinterFileMetadata() {
        return this.printerFileMetadata;
    }
}

