/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import java.util.EnumSet;
import java.util.Set;

public enum PrinterInterface {
    UNKNOWN(0, "Unknown"),
    INTERNAL_WIRED(1, "Internal Wired"),
    EXTERNAL_WIRED(2, "External Wired"),
    WIRELESS(4, "Wireless"),
    BLUETOOTH(8, "Bluetooth"),
    PARALLEL(16, "Parallel"),
    SERIAL(32, "Serial"),
    USB(64, "USB"),
    SD_CARD(128, "SD Card"),
    BATTERY(256, "Battery");

    private final int bitFieldValue;
    private final String printerInterfaceString;

    private PrinterInterface(int n2, String string2) {
        this.bitFieldValue = n2;
        this.printerInterfaceString = string2;
    }

    public int bitFieldValue() {
        return this.bitFieldValue;
    }

    public String toString() {
        return this.printerInterfaceString;
    }

    public static PrinterInterface intToEnum(int n) {
        PrinterInterface[] printerInterfaceArray;
        PrinterInterface printerInterface = UNKNOWN;
        for (PrinterInterface printerInterface2 : printerInterfaceArray = PrinterInterface.values()) {
            if (printerInterface2.bitFieldValue() != n) continue;
            printerInterface = printerInterface2;
            break;
        }
        return printerInterface;
    }

    public static Set<PrinterInterface> getEnumSetFromBitmask(int n) {
        PrinterInterface[] printerInterfaceArray = PrinterInterface.values();
        EnumSet<PrinterInterface> enumSet = EnumSet.noneOf(PrinterInterface.class);
        for (PrinterInterface printerInterface : printerInterfaceArray) {
            if ((n & printerInterface.bitFieldValue()) == 0) continue;
            enumSet.add(printerInterface);
        }
        return enumSet;
    }
}

