/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.NativeUsbAdapter;
import com.zebra.sdk.comm.internal.UsbUtils;
import com.zebra.sdk.printer.SGD;
import java.util.LinkedHashMap;
import java.util.Map;

public class UsbWindowsUtils {
    public static Map<String, String> loadDeviceIdMap(String string) throws ConnectionException {
        Object object;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        UsbUtils.addSymbolicNameAttributesToMap(string, linkedHashMap);
        String string2 = "";
        try {
            object = new NativeUsbAdapter();
            if (!NativeUsbAdapter.isDriverLoaded) {
                throw new ConnectionException("The native code dll is not loaded.");
            }
            int n = ((NativeUsbAdapter)object).Open(string);
            string2 = ((NativeUsbAdapter)object).GetDeviceIDString(n);
            ((NativeUsbAdapter)object).Close(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        UsbUtils.addDeviceIdArtributesToMap(linkedHashMap, string2);
        if (UsbUtils.isZMotifPrinter(linkedHashMap)) {
            object = UsbUtils.decodeZmotifSerialNumber((String)linkedHashMap.get("SERIAL_NUMBER"));
            linkedHashMap.put("SERIAL_NUMBER", (String)object);
        }
        return linkedHashMap;
    }

    public static Map<String, String> loadDeviceIdMap(String string, Connection connection) throws ConnectionException {
        Map<String, String> map = UsbWindowsUtils.loadDeviceIdMap(string);
        if (!UsbUtils.isCardPrinter(map)) {
            try {
                String string2 = SGD.GET("device.unique_id", connection);
                if (string2 != null && !string2.isEmpty()) {
                    map.put("SERIAL_NUMBER", string2);
                }
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
        }
        return map;
    }
}

