/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.settings.internal;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.settings.Setting;
import com.zebra.sdk.settings.SettingsException;
import com.zebra.sdk.settings.internal.SettingsBuilder;
import com.zebra.sdk.settings.internal.ZebraSettingsListI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ZebraSettingsList
implements ZebraSettingsListI {
    protected Map<String, Setting> allSettings = new LinkedHashMap<String, Setting>();

    protected abstract byte[] getUpdatedJsonData() throws Exception;

    protected void refresh() throws SettingsException {
        try {
            byte[] byArray = this.getUpdatedJsonData();
            if (byArray.length > 0) {
                LinkedHashMap<String, Setting> linkedHashMap = new LinkedHashMap<String, Setting>();
                SettingsBuilder settingsBuilder = new SettingsBuilder(linkedHashMap);
                settingsBuilder.parse(byArray);
                this.allSettings = linkedHashMap;
            }
        }
        catch (ConnectionException connectionException) {
            throw new SettingsException(connectionException.getLocalizedMessage());
        }
        catch (Exception exception) {
            throw new SettingsException("Malformed settings data");
        }
    }

    @Override
    public String getValue(String string) throws SettingsException, ConnectionException, ZebraIllegalArgumentException {
        if (this.getSettingById(string).isWriteOnly()) {
            throw new SettingsException("Setting [" + string + "] is write only");
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string));
        Map<String, String> map = this.getValues(arrayList);
        if (null == map || !map.containsKey(string)) {
            throw new SettingsException("Setting " + string + " not availble from device");
        }
        return map.get(string);
    }

    @Override
    public abstract Map<String, String> getValues(List<String> var1) throws SettingsException, ConnectionException, ZebraIllegalArgumentException;

    @Override
    public Set<String> getAllSettingIds() throws SettingsException {
        return this.getAllSettings().keySet();
    }

    @Override
    public Map<String, String> getAllSettingValues() throws SettingsException {
        this.refresh();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Set<String> set = this.getAllSettings().keySet();
        for (String string : set) {
            linkedHashMap.put(string, this.getAllSettings().get(string).getValue());
        }
        return linkedHashMap;
    }

    protected List<String> filterOutUnreadableSettings(List<String> list) throws SettingsException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (!this.getAllSettings().containsKey(string) || this.getSettingById(string).isWriteOnly()) continue;
            arrayList.add(string);
        }
        if (arrayList.isEmpty()) {
            throw new SettingsException("Found no valid settings to retrieve.");
        }
        return arrayList;
    }

    @Override
    public abstract void setSetting(String var1, String var2) throws SettingsException;

    protected void updateInternalState(String string, String string2) throws SettingsException {
        Setting setting = this.getSettingById(string);
        if (setting != null) {
            if (setting.isReadOnly()) {
                throw new SettingsException("Setting [" + string + "] is read only.");
            }
            try {
                if (!setting.isValid(string2)) {
                    throw new SettingsException("Setting [" + string + "] is not in range [" + setting.getRange() + "]");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingsException("Error in range check for [" + string + "] with value [" + string2 + "]");
            }
            if (setting.getValue() == null || !setting.getValue().equals(string2) || setting.isWriteOnly()) {
                setting.setValue(string2);
                Map<String, Setting> map = this.getAllSettings();
                if (map != null) {
                    map.remove(string);
                    map.put(string, setting);
                }
            }
        }
    }

    @Override
    public boolean isSettingReadOnly(String string) throws SettingsException {
        return this.getSettingById(string).isReadOnly();
    }

    @Override
    public boolean isSettingWriteOnly(String string) throws SettingsException {
        return this.getSettingById(string).isWriteOnly();
    }

    @Override
    public boolean isSettingClonable(String string) throws SettingsException {
        return this.getSettingById(string).getClone();
    }

    @Override
    public boolean isSettingArchivable(String string) throws SettingsException {
        return this.getSettingById(string).getArchive();
    }

    @Override
    public String getSettingRange(String string) throws SettingsException {
        return this.getSettingById(string).getRange();
    }

    @Override
    public boolean isSettingValid(String string, String string2) throws SettingsException {
        return this.getSettingById(string).isValid(string2);
    }

    @Override
    public Map<String, Setting> getAllSettings() throws SettingsException {
        if (this.allSettings == null || this.allSettings.isEmpty()) {
            this.refresh();
        }
        return this.allSettings;
    }

    protected Setting getSettingById(String string) throws SettingsException {
        Setting setting = this.getAllSettings().get(string);
        if (setting == null) {
            throw new SettingsException("Setting [" + string + "] not found.");
        }
        return setting;
    }

    @Override
    public String getSettingType(String string) throws SettingsException {
        return this.getSettingById(string).getType().toString();
    }

    @Override
    public Setting getSetting(String string) throws SettingsException {
        return this.getSettingById(string);
    }
}

