/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.PrinterAlert;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.operations.internal.PrinterOperationBase;
import com.zebra.sdk.settings.internal.AlertsUtilLinkOs;
import java.util.List;

public class ConfiguredAlertsGrabberOperation
extends PrinterOperationBase<List<PrinterAlert>> {
    private static final long serialVersionUID = 561030993363812422L;

    public ConfiguredAlertsGrabberOperation(Connection connection, PrinterLanguage printerLanguage) {
        super(connection, printerLanguage);
    }

    @Override
    public List<PrinterAlert> execute() throws ConnectionException {
        this.selectStatusChannelIfOpen();
        this.isOkToProceed();
        try {
            return new AlertsUtilLinkOs(this.connection).getAlerts();
        }
        catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
            throw new ConnectionException(zebraIllegalArgumentException.getLocalizedMessage());
        }
    }

    private void isOkToProceed() throws ConnectionException {
        if (this.isPrintingChannelInLineMode()) {
            throw new ConnectionException("Cannot retrieve settings from printer over printing channel when in line mode");
        }
    }
}

