/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.UsbConnection;
import com.zebra.sdk.comm.internal.ConnectionReestablisherBase;
import com.zebra.sdk.comm.internal.LibUsbUtils;
import com.zebra.sdk.comm.internal.NativeUsbAdapter;
import com.zebra.sdk.comm.internal.UsbWindowsUtils;
import com.zebra.sdk.printer.PrinterReconnectionHandler;
import com.zebra.sdk.printer.ZebraPrinterFactory;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.util.internal.Sleeper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class UsbConnectionReestablisher
extends ConnectionReestablisherBase
implements ConnectionReestablisher {
    public UsbConnectionReestablisher(Connection connection, long l) {
        super(connection, l);
    }

    @Override
    public void reestablishConnection(PrinterReconnectionHandler printerReconnectionHandler) throws DiscoveryException, ConnectionException, TimeoutException, ZebraPrinterLanguageUnknownException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = this.waitForUsbPrinterToComeOnlineViaSgdAndGetFwVer();
        try {
            String string = zebraPrinterLinkOs.getSettingValue("appl.name");
            printerReconnectionHandler.printerOnline(zebraPrinterLinkOs, string);
        }
        catch (Exception exception) {
            throw new ConnectionException(exception.getLocalizedMessage(), exception);
        }
    }

    protected ZebraPrinterLinkOs waitForUsbPrinterToComeOnlineViaSgdAndGetFwVer() throws TimeoutException, ZebraPrinterLanguageUnknownException {
        this.startTime = System.currentTimeMillis();
        String string = this.zebraPrinterConnection.getSimpleConnectionName();
        String string2 = ((UsbConnection)this.zebraPrinterConnection).getSerialNumber();
        int n = this.zebraPrinterConnection.getMaxTimeoutForRead();
        int n2 = this.zebraPrinterConnection.getTimeToWaitForMoreData();
        while (true) {
            try {
                Map<Object, Object> map = new HashMap();
                List<String> list = this.getEnumeratedPrinters();
                UsbConnection usbConnection = null;
                for (String string3 : list) {
                    usbConnection = new UsbConnection(string3, n, n2);
                    map = this.getPrinterIdMap(string3, usbConnection);
                    if (string.equals(string3) || string2.equals(map.get("SERIAL_NUMBER"))) break;
                    usbConnection = null;
                }
                if (usbConnection != null) {
                    this.zebraPrinterConnection = usbConnection;
                }
                this.zebraPrinterConnection.open();
                ZebraPrinterLinkOs zebraPrinterLinkOs = ZebraPrinterFactory.createLinkOsPrinter(ZebraPrinterFactory.getInstance(this.zebraPrinterConnection));
                if (zebraPrinterLinkOs == null) {
                    throw new ConnectionException("Printer is not responding");
                }
                return zebraPrinterLinkOs;
            }
            catch (ConnectionException connectionException) {
                try {
                    this.zebraPrinterConnection.close();
                }
                catch (ConnectionException connectionException2) {
                    // empty catch block
                }
                Sleeper.sleep(2500L);
                this.timeoutCheck();
                continue;
            }
            break;
        }
    }

    private Map<String, String> getPrinterIdMap(String string, Connection connection) {
        Map<String, String> map = new HashMap<String, String>();
        try {
            String string2 = System.getProperty("os.name").toLowerCase();
            map = string2.contains("windows") ? UsbWindowsUtils.loadDeviceIdMap(string, connection) : LibUsbUtils.loadDeviceIdMap(string, connection);
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        return map;
    }

    private List<String> getEnumeratedPrinters() throws ConnectionException {
        List<Object> list = new ArrayList();
        String string = System.getProperty("os.name").toLowerCase();
        list = string.contains("windows") ? Arrays.asList(NativeUsbAdapter.EnumeratePrinters()) : LibUsbUtils.enumeratePrinters();
        return list;
    }
}

