/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.device.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ProfileAssembler {
    private ZipOutputStream zos = null;
    private OutputStream bos = null;

    public void begin(OutputStream outputStream) {
        this.bos = new BufferedOutputStream(outputStream);
        this.zos = new ZipOutputStream(this.bos);
    }

    public void addSettings(InputStream inputStream) throws IOException {
        this.addEntry("settings.json", inputStream);
    }

    public void addAlerts(InputStream inputStream) throws IOException {
        this.addEntry("alerts.json", inputStream);
    }

    public void addSupplement(InputStream inputStream) throws IOException {
        this.addEntry("profileSupplement.txt", inputStream);
    }

    public void addFirmware(String string, InputStream inputStream) throws IOException {
        this.addEntry("firmwareFileUserSpecifiedName.txt", new ByteArrayInputStream(string.getBytes()));
        this.addEntry("firmwareFile.txt", inputStream);
    }

    public void addFiles(Map<String, InputStream> map) throws IOException {
        for (String string : map.keySet()) {
            InputStream inputStream = map.get(string);
            this.addEntry(string, inputStream);
        }
    }

    private void addEntry(String string, InputStream inputStream) throws IOException {
        this.zos.putNextEntry(new ZipEntry(string));
        byte[] byArray = new byte[16384];
        while (inputStream.available() > 0) {
            int n = inputStream.read(byArray);
            this.zos.write(byArray, 0, n);
        }
        this.zos.closeEntry();
    }

    public void end() throws IOException {
        this.zos.close();
        this.bos.close();
    }
}

