/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionWithWriteLogging;
import com.zebra.sdk.comm.MultichannelTcpConnection;
import com.zebra.sdk.comm.TcpConnection;
import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DiscoveredPrinterNetwork
extends DiscoveredPrinter {
    private static final long serialVersionUID = -8672214006905822089L;

    public DiscoveredPrinterNetwork(String string, int n) {
        super(string);
        this.discoSettings.put("ADDRESS", string);
        this.discoSettings.put("PORT_NUMBER", String.valueOf(n));
    }

    public DiscoveredPrinterNetwork(Map<String, String> map) {
        super(map.get("ADDRESS"));
        this.discoSettings = map;
    }

    @Override
    public Connection getConnection() {
        String string = (String)this.discoSettings.get("ADDRESS");
        String string2 = (String)this.discoSettings.get("PORT_NUMBER");
        String string3 = (String)this.discoSettings.get("JSON_PORT_NUMBER");
        ConnectionWithWriteLogging connectionWithWriteLogging = null != string3 && 0 != string3.length() && 0 != Integer.parseInt(string3) ? new MultichannelTcpConnection(string, Integer.parseInt(string2), Integer.parseInt(string3)) : new TcpConnection(string, Integer.parseInt(string2));
        return connectionWithWriteLogging;
    }

    @Override
    public boolean equals(Object object) {
        String string;
        if (!(object instanceof DiscoveredPrinterNetwork)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        DiscoveredPrinterNetwork discoveredPrinterNetwork = (DiscoveredPrinterNetwork)object;
        String string2 = (String)this.discoSettings.get("SERIAL_NUMBER");
        if (string2 == null || string2.isEmpty()) {
            string2 = "UNKNOWN";
        }
        if ((string = discoveredPrinterNetwork.getDiscoveryDataMap().get("SERIAL_NUMBER")) == null || string.isEmpty()) {
            string = "UNKNOWN";
        }
        return new EqualsBuilder().append((Object)string2.trim(), (Object)string.trim()).append((Object)this.address, (Object)discoveredPrinterNetwork.address).isEquals();
    }

    @Override
    public int hashCode() {
        String string = (String)this.discoSettings.get("SERIAL_NUMBER");
        if (string == null || string.isEmpty()) {
            string = "UNKNOWN";
        }
        return new HashCodeBuilder(47, 3).append((Object)this.address).append((Object)string.trim()).toHashCode();
    }
}

