/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.util.internal.Range;

public class DeleteFileCommand
extends Command {
    private static final int CONNECTION_ARG_INDEX = 0;
    private static final int FILE_ARG_INDEX = 1;

    public DeleteFileCommand() {
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "delete";
    }

    @Override
    public String getDescription() {
        return "Deletes a file on the printer's file system.";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        if (this.isVerbose) {
            String[] stringArray = PrinterUtil.deleteFileReportDeleted(this.getConnectionFromArgs(parsedArguments, parsedArguments.getArg(0)), parsedArguments.getArg(1));
            if (stringArray == null || stringArray.length == 0) {
                this.verbosePrint("No files deleted");
            } else {
                if (stringArray.length == 1) {
                    this.verbosePrint("Deleted 1 file:");
                } else {
                    this.verbosePrint("Deleted " + stringArray.length + " files:");
                }
                for (String string : stringArray) {
                    this.verbosePrint("\t" + string);
                }
            }
        } else {
            PrinterUtil.deleteFile(this.getConnectionFromArgs(parsedArguments, parsedArguments.getArg(0)), parsedArguments.getArg(1));
        }
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.TWO_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> <fileToDelete> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Delete a file on a ZDesigner Driver printer\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" FILE.TXT --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.DRIVER_OPTION.getLongName()));
        stringBuilder.append("Delete all files on the E drive\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 E:*.*%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Delete all ZPL files on the printer\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 \"*.ZPL\"%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        stringBuilder.append("Delete all ZPL files on a Driverless USB printer\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" \"*.ZPL\"%n", "java -jar ZSDK_API.jar", this.getCommandName()));
        return stringBuilder.toString();
    }
}

