/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm;

import com.zebra.sdk.comm.ConnectionA;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.internal.ConnectionI;
import com.zebra.sdk.comm.internal.ConnectionInfo;
import com.zebra.sdk.comm.internal.NotMyConnectionDataException;
import com.zebra.sdk.comm.internal.UsbConnectionI;
import com.zebra.sdk.comm.internal.UsbConnectionLibUsb;
import com.zebra.sdk.comm.internal.UsbConnectionReestablisher;
import com.zebra.sdk.comm.internal.UsbConnectionWindows;
import com.zebra.sdk.comm.internal.UsbUtils;
import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import com.zebra.sdk.printer.discovery.UsbDiscoverer;
import com.zebra.sdk.util.internal.ReflectionUtil;
import com.zebra.sdk.util.internal.RegexUtil;
import java.util.List;
import java.util.Map;

public class UsbConnection
extends ConnectionA
implements ConnectionI {
    private String serialNumber = null;
    protected String symbolicName = null;
    private byte[] temporaryReadBuffer = null;
    private UsbConnectionI usbConnection = null;

    public UsbConnection(String string) throws ConnectionException {
        this(string, 5000, 500);
    }

    public UsbConnection(String string, int n, int n2) throws ConnectionException {
        this.createNativeUsbConnection(string, n, n2);
    }

    private void createNativeUsbConnection(String string, int n, int n2) throws ConnectionException {
        this.symbolicName = string;
        this.maxTimeoutForRead = n;
        this.timeToWaitForMoreData = n2;
        String string2 = System.getProperty("os.name").toLowerCase();
        this.usbConnection = string2.contains("windows") ? new UsbConnectionWindows(string) : new UsbConnectionLibUsb(string);
        this.usbConnection.setMaxTimeoutForRead(n);
        this.usbConnection.setTimeToWaitForMoreData(n2);
        this.loadSerialNumber();
    }

    protected UsbConnection(ConnectionInfo connectionInfo) throws NotMyConnectionDataException, ConnectionException {
        DiscoveredPrinter[] discoveredPrinterArray;
        String string = connectionInfo.getMyData();
        String string2 = "^\\s*((?i)USB_DIRECT:)?([^:]+)\\s*$";
        List<String> list = RegexUtil.getMatches(string2, string);
        if (list.isEmpty()) {
            throw new NotMyConnectionDataException("USB Connection doesn't understand " + string);
        }
        this.symbolicName = string;
        if (list.size() > 2) {
            this.symbolicName = list.get(2);
        }
        for (DiscoveredPrinter discoveredPrinter : discoveredPrinterArray = this.getZebraUsbPrinters()) {
            if (!discoveredPrinter.address.endsWith(this.symbolicName.replace("\\", "").replace("?", ""))) continue;
            this.symbolicName = discoveredPrinter.address;
        }
        this.createNativeUsbConnection(this.symbolicName, 5000, 500);
    }

    protected DiscoveredPrinter[] getZebraUsbPrinters() throws ConnectionException {
        return UsbDiscoverer.getZebraUsbPrinters();
    }

    @Override
    public void open() throws ConnectionException {
        this.usbConnection.open();
        this.symbolicName = this.usbConnection.getConnectionAttributes().get("ADDRESS");
        this.isConnected = this.usbConnection.isConnected();
    }

    @Override
    public void close() throws ConnectionException {
        this.usbConnection.close();
        this.isConnected = this.usbConnection.isConnected();
    }

    @Override
    public void write(byte[] byArray) throws ConnectionException {
        this.usbConnection.write(byArray);
        this.writeToLogStream(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws ConnectionException {
        this.usbConnection.write(byArray, n, n2);
        this.writeToLogStream(byArray, n, n2);
    }

    @Override
    public int readChar() throws ConnectionException {
        if (this.isConnected) {
            byte[] byArray = this.read(1);
            if (byArray == null || byArray.length == 0) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public byte[] read(int n) throws ConnectionException {
        byte[] byArray = null;
        if (n > 1) {
            byArray = this.usbConnection.nativeRead(n);
        } else {
            this.bytesAvailable();
            if (this.temporaryReadBuffer != null) {
                if (n < 0 || n >= this.temporaryReadBuffer.length) {
                    byArray = new byte[this.temporaryReadBuffer.length];
                    System.arraycopy(this.temporaryReadBuffer, 0, byArray, 0, this.temporaryReadBuffer.length);
                    this.temporaryReadBuffer = null;
                } else {
                    byArray = new byte[n];
                    System.arraycopy(this.temporaryReadBuffer, 0, byArray, 0, n);
                    int n2 = this.temporaryReadBuffer.length - n;
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(this.temporaryReadBuffer, n, byArray2, 0, n2);
                    this.temporaryReadBuffer = byArray2;
                }
            }
        }
        return byArray;
    }

    @Override
    public int bytesAvailable() throws ConnectionException {
        int n = 0;
        try {
            if (this.temporaryReadBuffer != null) {
                n = this.temporaryReadBuffer.length;
                if (n == 0) {
                    this.temporaryReadBuffer = this.usbConnection.readFromPrinter();
                }
            } else {
                this.temporaryReadBuffer = this.usbConnection.readFromPrinter();
                if (this.temporaryReadBuffer == null) {
                    n = 0;
                } else if (this.temporaryReadBuffer.length == 1 && this.temporaryReadBuffer[0] == 0) {
                    n = 0;
                    this.temporaryReadBuffer = null;
                } else {
                    n = this.temporaryReadBuffer.length;
                }
            }
        }
        catch (Exception exception) {
            throw new ConnectionException("Failed to read from the USB port: " + this.symbolicName);
        }
        return n;
    }

    protected void loadSerialNumber() throws ConnectionException {
        Map<String, String> map = this.usbConnection.loadDeviceMap();
        if (this.serialNumber == null || this.serialNumber.isEmpty()) {
            this.serialNumber = map.get("SERIAL_NUMBER");
            if (this.serialNumber.isEmpty()) {
                this.serialNumber = map.get("MODEL");
            } else {
                map.put("SERIAL_NUMBER", this.serialNumber);
            }
        }
        this.serialNumber = this.usbConnection.getSerialNumber();
    }

    @Override
    public String getSimpleConnectionName() {
        this.symbolicName = this.usbConnection.getConnectionAttributes().get("ADDRESS");
        return this.symbolicName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    private String getConnectionBuilderPrefix() {
        return "USB_DIRECT";
    }

    @Override
    public String toString() {
        return this.getConnectionBuilderPrefix() + ":" + this.getSimpleConnectionName();
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        if (UsbUtils.isCardPrinter(this.usbConnection.getConnectionAttributes())) {
            return ReflectionUtil.loadUsbCardConnectionReestablisher(this, l);
        }
        return new UsbConnectionReestablisher(this, l);
    }

    @Override
    public void setMaxTimeoutForRead(int n) {
        this.usbConnection.setMaxTimeoutForRead(n);
    }

    @Override
    public int getMaxTimeoutForRead() {
        return this.usbConnection.getMaxTimeoutForRead();
    }

    @Override
    public String getManufacturer() {
        return this.usbConnection.getConnectionAttributes().get("MFG");
    }

    private Map<String, String> getConnectionAttributes() {
        if (this.usbConnection != null) {
            return this.usbConnection.getConnectionAttributes();
        }
        return null;
    }
}

