/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.ConnectionWithWriteLogging;
import com.zebra.sdk.comm.LogStreamException;
import com.zebra.sdk.comm.ResponseValidator;
import com.zebra.sdk.comm.internal.ZebraConnector;
import com.zebra.sdk.comm.internal.ZebraSocket;
import com.zebra.sdk.util.internal.Sleeper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ConnectionA
implements ConnectionWithWriteLogging {
    protected static final int DEFAULT_TIME_TO_WAIT_FOR_MORE_DATA = 500;
    protected static final int DEFAULT_MAX_TIMEOUT_FOR_READ = 5000;
    private int MAX_DATA_TO_WRITE_TO_STREAM_AT_ONCE = 1024;
    private static int SIZE_OF_STREAM_BUFFERS = 16384;
    protected int maxTimeoutForRead = 0;
    protected int timeToWaitForMoreData = 0;
    protected ZebraSocket commLink;
    protected OutputStream outputStream;
    protected InputStream inputStream;
    protected boolean isConnected = false;
    protected ZebraConnector zebraConnector;
    protected OutputStream myWriteLogStream;

    protected ConnectionA() {
    }

    @Override
    public void open() throws ConnectionException {
        if (this.isConnected) {
            return;
        }
        try {
            this.commLink = this.zebraConnector.open();
            this.outputStream = this.commLink.getOutputStream();
            this.inputStream = this.commLink.getInputStream();
            this.isConnected = true;
        }
        catch (Exception exception) {
            this.isConnected = false;
            this.throwAsConnectionException("Could not connect to device: ", exception);
        }
    }

    @Override
    public void close() throws ConnectionException {
        if (!this.isConnected) {
            return;
        }
        this.isConnected = false;
        try {
            this.outputStream.close();
            this.inputStream.close();
            this.commLink.close();
        }
        catch (IOException iOException) {
            this.throwAsConnectionException("Could not disconnect from device: ", iOException);
        }
    }

    @Override
    public void write(byte[] byArray) throws ConnectionException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(InputStream inputStream) throws ConnectionException {
        byte[] byArray = new byte[16384];
        try {
            int n = inputStream.read(byArray);
            while (n > -1) {
                this.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (IOException iOException) {
            this.throwAsConnectionException("Error writing to connection: ", iOException);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws ConnectionException {
        if (this.outputStream == null || !this.isConnected()) {
            throw new ConnectionException("The connection is not open");
        }
        try {
            int n3;
            int n4 = n;
            for (int i = n2; i > 0; i -= n3) {
                n3 = i > this.MAX_DATA_TO_WRITE_TO_STREAM_AT_ONCE ? this.MAX_DATA_TO_WRITE_TO_STREAM_AT_ONCE : i;
                this.outputStream.write(byArray, n4, n3);
                this.writeToLogStream(byArray, n4, n3);
                this.outputStream.flush();
                Sleeper.sleep(10L);
                n4 += n3;
            }
        }
        catch (IOException iOException) {
            this.throwAsConnectionException("Error writing to connection: ", iOException);
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public byte[] read() throws ConnectionException {
        return this.read(-1);
    }

    public byte[] read(int n) throws ConnectionException {
        int n2 = this.bytesAvailable();
        if (n2 > 0) {
            int n3 = n < 0 ? n2 : Math.min(n, n2);
            byte[] byArray = new byte[n3];
            try {
                this.inputStream.read(byArray);
            }
            catch (IOException iOException) {
                this.throwAsConnectionException("Error reading from connection: ", iOException);
            }
            return byArray;
        }
        return null;
    }

    @Override
    public void read(OutputStream outputStream) throws ConnectionException {
        while (this.bytesAvailable() > 0) {
            try {
                byte[] byArray = this.read(16384);
                outputStream.write(byArray);
            }
            catch (IOException iOException) {
                this.throwAsConnectionException("Error reading from connection: ", iOException);
            }
        }
    }

    @Override
    public int readChar() throws ConnectionException {
        try {
            return this.inputStream.read();
        }
        catch (IOException iOException) {
            this.throwAsConnectionException("Error reading from connection: ", iOException);
            return -1;
        }
    }

    @Override
    public int bytesAvailable() throws ConnectionException {
        try {
            return this.inputStream.available();
        }
        catch (IOException iOException) {
            this.throwAsConnectionException("Error reading from connection: ", iOException);
            return -1;
        }
    }

    @Override
    public void waitForData(int n) throws ConnectionException {
        long l = System.currentTimeMillis() + (long)n;
        while (this.bytesAvailable() == 0 && System.currentTimeMillis() < l) {
            Sleeper.sleep(50L);
        }
    }

    @Override
    public int getMaxTimeoutForRead() {
        return this.maxTimeoutForRead;
    }

    @Override
    public int getTimeToWaitForMoreData() {
        return this.timeToWaitForMoreData;
    }

    @Override
    public byte[] sendAndWaitForResponse(byte[] byArray, int n, int n2, String string) throws ConnectionException {
        if (!this.isConnected()) {
            throw new ConnectionException("No Printer Connection");
        }
        this.write(byArray);
        this.waitForData(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (this.bytesAvailable() > 0) {
            byte[] byArray2 = this.read();
            try {
                byteArrayOutputStream.write(byArray2);
            }
            catch (IOException iOException) {
                this.throwAsConnectionException(iOException.getMessage(), iOException);
            }
            if (!this.shouldWaitForData(byteArrayOutputStream.toString(), string)) continue;
            this.waitForData(n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void sendAndWaitForResponse(OutputStream outputStream, InputStream inputStream, int n, int n2, String string) throws ConnectionException {
        if (!this.isConnected()) {
            throw new ConnectionException("No Printer Connection");
        }
        this.write(inputStream);
        this.waitForData(n);
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (string != null) {
            byteArrayOutputStream = new ByteArrayOutputStream();
        }
        while (this.bytesAvailable() > 0) {
            byte[] byArray = this.read(SIZE_OF_STREAM_BUFFERS);
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.write(byArray);
                }
                outputStream.write(byArray);
            }
            catch (IOException iOException) {
                this.throwAsConnectionException(iOException.getMessage(), iOException);
            }
            if (string != null && !this.shouldWaitForData(byteArrayOutputStream.toString(), string)) continue;
            this.waitForData(n2);
        }
    }

    private boolean shouldWaitForData(String string, String string2) {
        if (string2 == null) {
            return true;
        }
        return !string.contains(string2);
    }

    @Override
    public byte[] sendAndWaitForValidResponse(byte[] byArray, int n, int n2, ResponseValidator responseValidator) throws ConnectionException {
        if (!this.isConnected()) {
            throw new ConnectionException("No Printer Connection");
        }
        this.write(byArray);
        this.waitForData(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (this.bytesAvailable() > 0) {
            byte[] byArray2 = this.read();
            try {
                byteArrayOutputStream.write(byArray2);
            }
            catch (IOException iOException) {
                this.throwAsConnectionException(iOException.getMessage(), iOException);
            }
            if (responseValidator.isResponseComplete(byteArrayOutputStream.toByteArray())) continue;
            this.waitForData(n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void sendAndWaitForValidResponse(OutputStream outputStream, InputStream inputStream, int n, int n2, ResponseValidator responseValidator) throws ConnectionException {
        if (!this.isConnected()) {
            throw new ConnectionException("No Printer Connection");
        }
        this.write(inputStream);
        this.waitForData(n);
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (responseValidator != null) {
            byteArrayOutputStream = new ByteArrayOutputStream();
        }
        while (this.bytesAvailable() > 0) {
            byte[] byArray = this.read(SIZE_OF_STREAM_BUFFERS);
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.write(byArray);
                }
                outputStream.write(byArray);
            }
            catch (IOException iOException) {
                this.throwAsConnectionException(iOException.getMessage(), iOException);
            }
            if (responseValidator != null && responseValidator.isResponseComplete(byteArrayOutputStream.toByteArray())) continue;
            this.waitForData(n2);
        }
    }

    @Override
    public void setMaxTimeoutForRead(int n) {
        this.maxTimeoutForRead = n;
    }

    @Override
    public void setTimeToWaitForMoreData(int n) {
        this.timeToWaitForMoreData = n;
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        throw new ConnectionException("Automatic reconnection is not supported for this connection type");
    }

    @Override
    public void addWriteLogStream(OutputStream outputStream) {
        this.myWriteLogStream = outputStream;
    }

    protected void writeToLogStream(byte[] byArray, int n, int n2) throws LogStreamException {
        if (null != this.myWriteLogStream) {
            try {
                this.myWriteLogStream.write(byArray, n, n2);
            }
            catch (IOException iOException) {
                throw new LogStreamException("Error writing to log: " + iOException.getLocalizedMessage());
            }
        }
    }

    public void setMaxDataToWrite(int n) {
        this.MAX_DATA_TO_WRITE_TO_STREAM_AT_ONCE = n;
    }

    public int getMaxDataToWrite() {
        return this.MAX_DATA_TO_WRITE_TO_STREAM_AT_ONCE;
    }

    public byte[] read(int n, boolean bl) throws ConnectionException {
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        byte[] byArray = null;
        byte[] byArray2 = new byte[n];
        do {
            try {
                n3 = this.inputStream.read(byArray2, n2, n4);
                if (n3 > 0) {
                    n5 += n3;
                    n2 += n3;
                    n4 -= n3;
                }
                if (!bl || n5 <= 0) continue;
                break;
            }
            catch (IOException iOException) {
                this.throwAsConnectionException("Error reading from connection: ", iOException);
            }
        } while (n5 < n);
        if (n5 > 0) {
            byArray = new byte[n5];
            System.arraycopy(byArray2, 0, byArray, 0, n5);
        }
        return byArray;
    }

    public String getManufacturer() {
        return "";
    }

    public void setReadTimeout(int n) throws ConnectionException {
        if (this.commLink != null) {
            try {
                this.commLink.setReadTimeout(n);
            }
            catch (IOException iOException) {
                this.throwAsConnectionException(iOException.getMessage(), iOException);
            }
        }
    }

    private void throwAsConnectionException(String string, Exception exception) throws ConnectionException {
        if (string == null) {
            string = "";
        }
        String string2 = exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName();
        throw new ConnectionException(string + string2, exception);
    }
}

