/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.settings.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.PrinterAlert;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.settings.AlertCondition;
import com.zebra.sdk.settings.AlertDestination;
import com.zebra.sdk.settings.internal.ConnectionUtil;
import com.zebra.sdk.settings.internal.JsonHelper;
import com.zebra.sdk.settings.internal.JsonValidator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AlertsUtilLinkOs {
    private Connection connection;

    public AlertsUtilLinkOs(ZebraPrinterLinkOs zebraPrinterLinkOs) {
        this.connection = zebraPrinterLinkOs.getConnection();
    }

    public AlertsUtilLinkOs(Connection connection) {
        this.connection = connection;
    }

    public List<PrinterAlert> getAlerts() throws ZebraIllegalArgumentException, ConnectionException {
        return this.getConfiguredAlerts();
    }

    public void setAlerts(List<PrinterAlert> list) throws ConnectionException {
        this.sendAlertsViaSgd(list);
    }

    public static void setAlerts(List<PrinterAlert> list, Connection connection) throws ConnectionException {
        new AlertsUtilLinkOs(connection).sendAlertsViaSgd(list);
    }

    private void sendAlertsViaSgd(List<PrinterAlert> list) throws ConnectionException {
        for (PrinterAlert printerAlert : list) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("alerts.add", this.getAlertSgdValue(printerAlert));
            byte[] byArray = JsonHelper.buildSetCommand(linkedHashMap);
            this.connection = ConnectionUtil.selectConnection(this.connection);
            this.connection.sendAndWaitForValidResponse(byArray, this.connection.getMaxTimeoutForRead(), this.connection.getTimeToWaitForMoreData(), new JsonValidator());
        }
    }

    private String getAlertSgdValue(PrinterAlert printerAlert) {
        String string = printerAlert.isOnSet() ? "Y" : "N";
        String string2 = printerAlert.isOnClear() ? "Y" : "N";
        String string3 = (Object)((Object)printerAlert.getCondition()) + "," + printerAlert.getDestinationAsSgdString() + "," + string + "," + string2 + "," + printerAlert.getDestinationAddress() + "," + printerAlert.getPort() + ",N," + printerAlert.getSgdName();
        return string3;
    }

    private ArrayList<PrinterAlert> getConfiguredAlerts() throws ZebraIllegalArgumentException, ConnectionException {
        ArrayList<PrinterAlert> arrayList = new ArrayList<PrinterAlert>();
        Connection connection = ConnectionUtil.selectConnection(this.connection);
        byte[] byArray = connection.sendAndWaitForValidResponse("{}{\"alerts.configured\":null}".getBytes(), connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData(), new JsonValidator());
        Map<String, String> map = JsonHelper.parseGetResponse(byArray);
        String string = map.get("alerts.configured");
        if (!string.trim().equals("")) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\|")) {
                String[] stringArray2 = string2.split(",");
                if (stringArray2.length != 7 && stringArray2.length != 8) {
                    throw new ZebraIllegalArgumentException("Invalid alert [" + string2 + "] from printer.");
                }
                AlertCondition alertCondition = AlertCondition.createAlertCondition(stringArray2[0]);
                AlertDestination alertDestination = AlertDestination.createAlertDestination(stringArray2[1]);
                boolean bl = stringArray2[2].equals("Y");
                boolean bl2 = stringArray2[3].equals("Y");
                String string3 = stringArray2[4];
                String string4 = stringArray2[5];
                boolean bl3 = stringArray2[6].equals("Y");
                String string5 = "";
                if (stringArray2.length > 7) {
                    string5 = stringArray2[7];
                }
                try {
                    arrayList.add(new PrinterAlert(alertCondition, alertDestination, string5, bl, bl2, string3, Integer.parseInt(string4), bl3));
                }
                catch (NumberFormatException numberFormatException) {
                    arrayList.add(new PrinterAlert(alertCondition, alertDestination, string5, bl, bl2, string3, 0, bl3));
                }
            }
        }
        return arrayList;
    }

    public void removeAllAlerts() throws ConnectionException {
        this.connection = ConnectionUtil.selectConnection(this.connection);
        this.connection.sendAndWaitForValidResponse("{}{\"alerts.configured\":\"\"}".getBytes(), this.connection.getMaxTimeoutForRead(), this.connection.getTimeToWaitForMoreData(), new JsonValidator());
    }
}

