/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.PrinterStatus;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.internal.FileUtilZpl;
import com.zebra.sdk.printer.internal.FormatUtilZpl;
import com.zebra.sdk.printer.internal.GraphicsUtilZpl;
import com.zebra.sdk.printer.internal.PrinterStatusZpl;
import com.zebra.sdk.printer.internal.ToolsUtilZpl;
import com.zebra.sdk.printer.internal.ZebraPrinterA;
import com.zebra.sdk.settings.internal.JsonValidator;
import com.zebra.sdk.util.internal.StringUtilities;
import java.io.IOException;
import java.util.Map;

public class ZebraPrinterZpl
extends ZebraPrinterA {
    PrinterLanguage language = null;

    public ZebraPrinterZpl(Connection connection) {
        super(connection);
        this.fileUtil = new FileUtilZpl(connection);
        this.formatUtil = new FormatUtilZpl(connection);
        this.graphicsUtil = new GraphicsUtilZpl(connection);
        this.toolsUtil = new ToolsUtilZpl(connection);
    }

    @Override
    public PrinterLanguage getPrinterControlLanguage() {
        try {
            this.language = this.obtainLanguage(this.connection);
        }
        catch (Exception exception) {
            this.language = PrinterLanguage.ZPL;
        }
        return this.language;
    }

    @Override
    public PrinterStatus getCurrentStatus() throws ConnectionException {
        PrinterStatusZpl printerStatusZpl = null;
        printerStatusZpl = new PrinterStatusZpl(this.connection);
        return printerStatusZpl;
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
        this.fileUtil = new FileUtilZpl(this.connection);
        this.formatUtil = new FormatUtilZpl(this.connection);
        this.graphicsUtil = new GraphicsUtilZpl(this.connection);
        this.toolsUtil = new ToolsUtilZpl(this.connection);
    }

    private PrinterLanguage obtainLanguage(Connection connection) throws RuntimeException, ConnectionException, ZebraPrinterLanguageUnknownException {
        return this.language == null ? this.queryPrinterLanguage(connection) : this.language;
    }

    private PrinterLanguage queryPrinterLanguage(Connection connection) throws RuntimeException, ConnectionException, ZebraPrinterLanguageUnknownException {
        if (connection instanceof MultichannelConnection) {
            MultichannelConnection multichannelConnection = (MultichannelConnection)connection;
            if (multichannelConnection.getStatusChannel().isConnected()) {
                return this.getLanguageViaJson(multichannelConnection.getStatusChannel());
            }
        } else if (connection instanceof StatusConnection) {
            return this.getLanguageViaJson(connection);
        }
        return this.getLanguageViaSgd(connection);
    }

    private PrinterLanguage getLanguageViaSgd(Connection connection) throws ConnectionException, ZebraPrinterLanguageUnknownException {
        String string = SGD.GET("device.languages", connection);
        return PrinterLanguage.getLanguage(string);
    }

    private PrinterLanguage getLanguageViaJson(Connection connection) throws ConnectionException, ZebraPrinterLanguageUnknownException {
        byte[] byArray = connection.sendAndWaitForValidResponse("{}{\"device.languages\":null}".getBytes(), connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData(), new JsonValidator());
        try {
            Map<String, String> map = StringUtilities.convertKeyValueJsonToMap(byArray);
            return PrinterLanguage.getLanguage(map.get("device.languages"));
        }
        catch (IOException iOException) {
            throw new ZebraPrinterLanguageUnknownException("Zebra printer language could not be determined for " + connection.toString());
        }
    }
}

