/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.util.internal.Sleeper;
import java.io.IOException;
import java.io.InputStream;

public abstract class PrinterConnectionInputStreamBase
extends InputStream {
    private Connection printerConnection = null;
    private long lastDataReceivedTime = 0L;
    private StringBuffer terminationQueue = null;
    private boolean endStreamOnNextRead = false;
    private long maxTimeToWaitForMoreData = 0L;
    protected String terminator = null;

    public PrinterConnectionInputStreamBase(Connection connection, long l) {
        this.printerConnection = connection;
        this.maxTimeToWaitForMoreData = l;
        this.terminator = null;
        this.terminationQueue = new StringBuffer();
        this.lastDataReceivedTime = System.currentTimeMillis();
    }

    @Override
    public int read() throws IOException {
        int n = -1;
        long l = 0L;
        if (this.endStreamOnNextRead) {
            return -1;
        }
        try {
            do {
                n = this.printerConnection.readChar();
                l = System.currentTimeMillis() - this.lastDataReceivedTime;
                if (n != -1) {
                    this.lastDataReceivedTime = System.currentTimeMillis();
                    this.setTerminatorBasedOnData(n);
                    this.handleTerminationOfStream((char)n);
                    continue;
                }
                Sleeper.sleep(50L);
            } while (n == -1 && l < this.maxTimeToWaitForMoreData);
        }
        catch (ConnectionException connectionException) {
            throw new IOException(connectionException.getLocalizedMessage());
        }
        return n;
    }

    protected abstract void setTerminatorBasedOnData(int var1);

    private void handleTerminationOfStream(char c) {
        if (this.terminator != null) {
            if (this.terminationQueue.length() >= this.terminator.length()) {
                this.terminationQueue.deleteCharAt(0);
            }
            this.terminationQueue.append(c);
            if (this.terminator.equals(this.terminationQueue.toString())) {
                this.endStreamOnNextRead = true;
            }
        }
    }
}

