/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import java.util.EnumSet;
import java.util.Set;

public enum PrinterWarning {
    NONE(0, 0, "None"),
    HEAD_UNDER_TEMP(2, 4096, "Head Cold"),
    RIBBON_IN(2, 8192, "Ribbon In"),
    BATTERY_LOW(2, 16384, "Battery Low"),
    RFID_ERROR(2, 32768, "RFID Error");

    private final int bitFieldValue;
    private final int segment;
    private final String printerWarningString;

    private PrinterWarning(int n2, int n3, String string2) {
        this.bitFieldValue = n3;
        this.segment = n2;
        this.printerWarningString = string2;
    }

    public int bitFieldValue() {
        return this.bitFieldValue;
    }

    public int segment() {
        return this.segment;
    }

    public String toString() {
        return this.printerWarningString;
    }

    public static PrinterWarning intToEnum(int n, int n2) {
        PrinterWarning[] printerWarningArray;
        PrinterWarning printerWarning = NONE;
        for (PrinterWarning printerWarning2 : printerWarningArray = PrinterWarning.values()) {
            if (printerWarning2.bitFieldValue() != n2 || printerWarning2.segment() != n) continue;
            printerWarning = printerWarning2;
            break;
        }
        return printerWarning;
    }

    public static Set<PrinterWarning> getEnumSetFromBitmask(int n, int n2) {
        PrinterWarning[] printerWarningArray = PrinterWarning.values();
        EnumSet<PrinterWarning> enumSet = EnumSet.noneOf(PrinterWarning.class);
        for (PrinterWarning printerWarning : printerWarningArray) {
            if ((n2 & printerWarning.bitFieldValue()) == 0 || printerWarning.segment() != n) continue;
            enumSet.add(printerWarning);
        }
        return enumSet;
    }
}

