/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.internal;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.FtpFileHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FTP {
    private static final String DEFAULT_USER = "user";
    private static final String DEFAULT_PASSWORD = "1234";
    String server;
    String user;
    String password;
    FTPClient client;

    public FTP(String string, String string2, String string3) {
        this.server = string;
        this.user = string2 == null ? DEFAULT_USER : string2;
        this.password = string3 == null ? DEFAULT_PASSWORD : string3;
        this.client = new FTPClient();
    }

    public void getFile(OutputStream outputStream, String string) throws ConnectionException {
        try {
            this.client.connect(this.server);
            this.client.login(this.user, this.password);
            this.client.setFileType(2);
            int n = this.client.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)n)) {
                this.client.disconnect();
                throw new ConnectionException("Could not connect to printer over FTP, make sure FTP is enabled");
            }
            this.client.retrieveFile(string, outputStream);
            return;
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
        finally {
            if (this.client.isConnected()) {
                try {
                    this.client.disconnect();
                }
                catch (IOException iOException) {
                    throw new ConnectionException(iOException.getLocalizedMessage());
                }
            }
        }
    }

    public void putFile(String string, String string2, byte[] byArray) throws ConnectionException {
        this.putFile(string, string2, new ByteArrayInputStream(byArray));
    }

    public void putFile(String string, String string2, InputStream inputStream) throws ConnectionException {
        this.putFiles(Arrays.asList(new FtpFileHolder(string, string2, inputStream)));
    }

    public void putFiles(List<FtpFileHolder> list) throws ConnectionException {
        try {
            this.client.connect(this.server);
            this.client.login(this.user, this.password);
            this.client.setFileType(2);
            for (FtpFileHolder ftpFileHolder : list) {
                if (!ftpFileHolder.pathOnServer.endsWith("/")) {
                    ftpFileHolder.pathOnServer = ftpFileHolder.pathOnServer + "/";
                }
                this.client.makeDirectory(ftpFileHolder.pathOnServer);
                String string = ftpFileHolder.fileName.replaceAll(":", "_");
                this.client.storeFile(ftpFileHolder.pathOnServer + string, ftpFileHolder.fileStream);
            }
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
        finally {
            if (this.client.isConnected()) {
                try {
                    this.client.disconnect();
                }
                catch (IOException iOException) {
                    throw new ConnectionException(iOException.getLocalizedMessage());
                }
            }
        }
    }

    public void deleteAllFilesAndSubDirectories(List<String> list) throws ConnectionException {
        try {
            this.client.connect(this.server);
            this.client.login(this.user, this.password);
            for (String string : list) {
                FTPFile[] fTPFileArray;
                if (!string.endsWith("/")) {
                    string = string + "/";
                }
                this.client.changeWorkingDirectory(string);
                for (FTPFile fTPFile : fTPFileArray = this.client.listFiles()) {
                    this.deleteFile(fTPFile, this.client);
                }
                this.client.changeWorkingDirectory("..");
            }
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
        finally {
            if (this.client.isConnected()) {
                try {
                    this.client.disconnect();
                }
                catch (IOException iOException) {
                    throw new ConnectionException(iOException.getLocalizedMessage());
                }
            }
        }
    }

    private void deleteFile(FTPFile fTPFile, FTPClient fTPClient) throws IOException {
        if (fTPFile.isDirectory()) {
            fTPClient.changeWorkingDirectory(fTPFile.getName());
            for (FTPFile fTPFile2 : fTPClient.listFiles()) {
                this.deleteFile(fTPFile2, fTPClient);
            }
            fTPClient.changeWorkingDirectory("..");
            fTPClient.removeDirectory(fTPFile.getName());
        }
        fTPClient.deleteFile(fTPFile.getName());
    }
}

