/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.printer.DriveType;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.PrinterObjectProperties;
import com.zebra.sdk.printer.StorageInfo;
import com.zebra.sdk.printer.internal.FileUtilZpl;
import com.zebra.sdk.printer.operations.internal.PrinterOperationCaresAboutLinkOsVersion;
import com.zebra.sdk.printer.operations.internal.StorageInfoGrabber;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ObjectsListingOperation
extends PrinterOperationCaresAboutLinkOsVersion<List<PrinterObjectProperties>> {
    private static final long serialVersionUID = 8426279194940766859L;
    private final Set<DriveType> driveTypes;

    public ObjectsListingOperation(Connection connection, PrinterLanguage printerLanguage, LinkOsInformation linkOsInformation) {
        this(connection, printerLanguage, linkOsInformation, new HashSet<DriveType>());
    }

    public ObjectsListingOperation(Connection connection, PrinterLanguage printerLanguage, LinkOsInformation linkOsInformation, Set<DriveType> set) {
        super(connection, printerLanguage, linkOsInformation);
        this.driveTypes = set;
    }

    @Override
    public List<PrinterObjectProperties> execute() throws ConnectionException {
        this.selectProperChannel();
        this.isOkToProceed();
        return this.retrieveObjectListing();
    }

    private List<PrinterObjectProperties> retrieveObjectListing() throws ConnectionException {
        try {
            Object object = new ArrayList<StorageInfo>();
            if (this.driveTypes != null && this.driveTypes.size() > 0) {
                object = new StorageInfoGrabber(this.connection, this.printerLanguage, this.linkOsInformation).execute();
            }
            if (this.shouldRetrieveViaFileListing()) {
                return new FileUtilZpl(this.connection).retrieveObjectsPropertiesWithCrc32((List<StorageInfo>)object, this.driveTypes, this.printerLanguage);
            }
            if (this.isLinkOs2_5_OrHigher()) {
                return new FileUtilZpl(this.connection).retrieveObjectsPropertiesWithCrc32((List<StorageInfo>)object, this.driveTypes, this.printerLanguage);
            }
            return new FileUtilZpl(this.connection).retrieveObjectsProperties((List<StorageInfo>)object, this.driveTypes);
        }
        catch (Exception exception) {
            throw new ConnectionException(exception.getLocalizedMessage());
        }
    }

    private void isOkToProceed() throws ConnectionException {
        if (!this.isLinkOs2_5_OrHigher()) {
            if (this.connection instanceof StatusConnection) {
                throw new ConnectionException("Cannot retrieve object listing over the status channel on this version of firmware");
            }
            if (this.printerLanguage == PrinterLanguage.LINE_PRINT) {
                throw new ConnectionException("Cannot retrieve object listing when in line print mode on this version of firmware");
            }
        }
    }

    private boolean shouldRetrieveViaFileListing() {
        return this.isLinkOs2_5_OrHigher() && (this.printerLanguage != PrinterLanguage.LINE_PRINT || this.connection instanceof StatusConnection);
    }
}

