/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer;

import com.zebra.sdk.printer.PrinterStatus;
import com.zebra.sdk.util.internal.StringUtilities;

public class PrinterStatusMessages {
    public static final String HEAD_OPEN_MSG = "HEAD OPEN";
    public static final String HEAD_TOO_HOT_MSG = "HEAD TOO HOT";
    public static final String PAPER_OUT_MSG = "PAPER OUT";
    public static final String RIBBON_OUT_MSG = "RIBBON OUT";
    public static final String RECEIVE_BUFFER_FULL_MSG = "RECEIVE BUFFER FULL";
    public static final String PAUSE_MSG = "PAUSE";
    public static final String NULL_MSG = "INVALID STATUS";
    private PrinterStatus printerStatus;

    public PrinterStatusMessages(PrinterStatus printerStatus) {
        this.printerStatus = printerStatus;
    }

    public String[] getStatusMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.printerStatus == null) {
            stringBuffer.append(NULL_MSG);
            stringBuffer.append(";");
            return new String[]{stringBuffer.toString()};
        }
        if (this.printerStatus.isHeadOpen) {
            stringBuffer.append(HEAD_OPEN_MSG);
            stringBuffer.append(";");
        }
        if (this.printerStatus.isHeadTooHot) {
            stringBuffer.append(HEAD_TOO_HOT_MSG);
            stringBuffer.append(";");
        }
        if (this.printerStatus.isPaperOut) {
            stringBuffer.append(PAPER_OUT_MSG);
            stringBuffer.append(";");
        }
        if (this.printerStatus.isRibbonOut) {
            stringBuffer.append(RIBBON_OUT_MSG);
            stringBuffer.append(";");
        }
        if (this.printerStatus.isReceiveBufferFull) {
            stringBuffer.append(RECEIVE_BUFFER_FULL_MSG);
            stringBuffer.append(";");
        }
        if (this.printerStatus.isPaused) {
            stringBuffer.append(PAUSE_MSG);
            stringBuffer.append(";");
        }
        if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ';') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return StringUtilities.split(stringBuffer.toString(), ";");
    }
}

