/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.device;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.device.Device;
import com.zebra.sdk.device.FileUtil;
import com.zebra.sdk.device.FileUtilLinkOs;
import com.zebra.sdk.device.ProgressMonitor;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.graphics.ZebraImageI;
import com.zebra.sdk.graphics.internal.ZebraImageInternal;
import com.zebra.sdk.printer.AlertProvider;
import com.zebra.sdk.printer.FontConverterZpl;
import com.zebra.sdk.printer.FontUtil;
import com.zebra.sdk.printer.GraphicsUtil;
import com.zebra.sdk.printer.PrinterAlert;
import com.zebra.sdk.printer.PrinterObjectProperties;
import com.zebra.sdk.printer.StorageInfo;
import com.zebra.sdk.printer.internal.GraphicsConversionUtilZpl;
import com.zebra.sdk.printer.internal.PrinterFilePropertiesZpl;
import com.zebra.sdk.printer.internal.ProfileHelper;
import com.zebra.sdk.settings.AlertCondition;
import com.zebra.sdk.settings.Setting;
import com.zebra.sdk.settings.SettingsException;
import com.zebra.sdk.settings.internal.ZebraSettingsListFromProfile;
import com.zebra.sdk.settings.internal.ZebraSettingsListI;
import com.zebra.sdk.util.internal.FileReader;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.FileWrapper;
import com.zebra.sdk.util.internal.PrinterFilePath;
import com.zebra.sdk.util.internal.ReflectionUtil;
import com.zebra.sdk.util.internal.ZipUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Profile
implements Device,
FileUtil,
FontUtil,
AlertProvider,
FileUtilLinkOs,
GraphicsUtil {
    private final String pathToProfile;
    private ZebraSettingsListI profileBasedSettingsList = null;

    public Profile(String string) throws FileNotFoundException {
        this.pathToProfile = string;
        this.profileBasedSettingsList = new ZebraSettingsListFromProfile(this.pathToProfile);
    }

    public void addSupplement(byte[] byArray) throws IOException {
        new ZipUtil(this.pathToProfile).addEntry("profileSupplement.txt", byArray);
    }

    public String getSupplement() throws FileNotFoundException, IOException {
        return new ZipUtil(this.pathToProfile).getEntryContents("profileSupplement.txt");
    }

    public void addFirmware(String string) throws IOException {
        byte[] byArray = new File(string).getName().getBytes();
        new ZipUtil(this.pathToProfile).addEntry("firmwareFile.txt", new File(string), byArray);
    }

    public void addFirmware(String string, byte[] byArray) throws IOException {
        new ZipUtil(this.pathToProfile).addEntry("firmwareFile.txt", byArray, string.getBytes());
    }

    public void removeFirmware() throws IOException {
        new ZipUtil(this.pathToProfile).removeEntry("firmwareFileUserSpecifiedName.txt");
        new ZipUtil(this.pathToProfile).removeEntry("firmwareFile.txt");
    }

    public String getFirmwareFilename() throws FileNotFoundException, IOException {
        String string = new ZipUtil(this.pathToProfile).getEntryExtraContent("firmwareFile.txt");
        if (string.isEmpty()) {
            string = new ZipUtil(this.pathToProfile).getEntryContents("firmwareFileUserSpecifiedName.txt");
        }
        return string;
    }

    @Override
    public Set<String> getAvailableSettings() throws SettingsException {
        return this.getAllSettingValues().keySet();
    }

    @Override
    public String getSettingValue(String string) throws SettingsException {
        Map<String, String> map = this.getAllSettingValues();
        if (!map.containsKey(string)) {
            throw new SettingsException();
        }
        return map.get(string);
    }

    @Override
    public Map<String, String> getSettingsValues(List<String> list) throws SettingsException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Map<String, String> map = this.getAllSettingValues();
        for (String string : list) {
            if (!map.containsKey(string)) continue;
            linkedHashMap.put(string, map.get(string));
        }
        return linkedHashMap;
    }

    @Override
    public Map<String, String> getAllSettingValues() throws SettingsException {
        return this.profileBasedSettingsList.getAllSettingValues();
    }

    @Override
    public void setSetting(String string, String string2) throws SettingsException {
        this.profileBasedSettingsList.setSetting(string, string2);
    }

    @Override
    public void setSettings(Map<String, String> map) throws SettingsException {
        this.profileBasedSettingsList.setSettings(map);
    }

    @Override
    public String getSettingRange(String string) throws SettingsException {
        try {
            return this.profileBasedSettingsList.getSettingRange(string);
        }
        catch (Exception exception) {
            throw new SettingsException(exception.getLocalizedMessage());
        }
    }

    @Override
    public boolean isSettingValid(String string, String string2) throws SettingsException {
        try {
            return this.profileBasedSettingsList.isSettingValid(string, string2);
        }
        catch (Exception exception) {
            throw new SettingsException(exception.getLocalizedMessage());
        }
    }

    @Override
    public boolean isSettingReadOnly(String string) throws SettingsException {
        try {
            return this.profileBasedSettingsList.isSettingReadOnly(string);
        }
        catch (Exception exception) {
            throw new SettingsException(exception.getLocalizedMessage());
        }
    }

    @Override
    public boolean isSettingWriteOnly(String string) throws SettingsException {
        try {
            return this.profileBasedSettingsList.isSettingWriteOnly(string);
        }
        catch (Exception exception) {
            throw new SettingsException(exception.getLocalizedMessage());
        }
    }

    @Override
    public String getSettingType(String string) throws SettingsException {
        try {
            return this.profileBasedSettingsList.getSettingType(string);
        }
        catch (Exception exception) {
            throw new SettingsException(exception.getLocalizedMessage());
        }
    }

    public Map<String, String> getArchivableSettingValues() throws SettingsException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Set<String> set = this.getAvailableSettings();
        for (String string : set) {
            try {
                if (!this.shouldArchive(string)) continue;
                linkedHashMap.put(string, this.profileBasedSettingsList.getValue(string));
            }
            catch (SettingsException settingsException) {
            }
            catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
            }
            catch (ConnectionException connectionException) {}
        }
        return linkedHashMap;
    }

    private boolean shouldArchive(String string) throws SettingsException {
        return this.profileBasedSettingsList.isSettingArchivable(string) && false == this.profileBasedSettingsList.isSettingWriteOnly(string) && false == this.profileBasedSettingsList.isSettingReadOnly(string);
    }

    private boolean shouldClone(String string) throws SettingsException {
        return this.profileBasedSettingsList.isSettingClonable(string) && false == this.profileBasedSettingsList.isSettingWriteOnly(string) && false == this.profileBasedSettingsList.isSettingReadOnly(string);
    }

    public Map<String, String> getClonableSettingValues() throws SettingsException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Set<String> set = this.getAvailableSettings();
        for (String string : set) {
            try {
                if (!this.shouldClone(string)) continue;
                linkedHashMap.put(string, this.profileBasedSettingsList.getValue(string));
            }
            catch (SettingsException settingsException) {
            }
            catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
            }
            catch (ConnectionException connectionException) {}
        }
        return linkedHashMap;
    }

    @Override
    public List<PrinterAlert> getConfiguredAlerts() throws ZebraIllegalArgumentException {
        try {
            return ProfileHelper.getAlertsFromJson(this.pathToProfile);
        }
        catch (Exception exception) {
            throw new ZebraIllegalArgumentException(exception.getMessage());
        }
    }

    @Override
    public void configureAlert(PrinterAlert printerAlert) throws ConnectionException {
        try {
            int n;
            List<PrinterAlert> list = ProfileHelper.getAlertsFromJson(this.pathToProfile);
            PrinterAlert printerAlert2 = printerAlert;
            for (n = 0; n < list.size(); ++n) {
                if (!this.isMatchingAlert(list.get(n), printerAlert2)) continue;
                list.remove(n);
                break;
            }
            int n2 = n = !printerAlert2.isOnSet() && !printerAlert2.isOnClear() ? 1 : 0;
            if (n == 0) {
                list.add(printerAlert);
            }
            ProfileHelper.commitAlertsToProfile(this.pathToProfile, list);
        }
        catch (Exception exception) {
            throw new ConnectionException(exception.getLocalizedMessage());
        }
    }

    private boolean isMatchingAlert(PrinterAlert printerAlert, PrinterAlert printerAlert2) {
        boolean bl = printerAlert2.getCondition() == printerAlert.getCondition() && printerAlert2.getDestination() == printerAlert.getDestination();
        boolean bl2 = bl && printerAlert2.getCondition() == AlertCondition.SGD_SET && false == printerAlert.getSgdName().equals(printerAlert2.getSgdName());
        return bl && false == bl2;
    }

    @Override
    public void configureAlerts(List<PrinterAlert> list) throws ConnectionException {
        for (PrinterAlert printerAlert : list) {
            this.configureAlert(printerAlert);
        }
    }

    @Override
    public void removeAlert(PrinterAlert printerAlert) throws ConnectionException {
        if (printerAlert instanceof PrinterAlert) {
            this.configureAlert(new PrinterAlert(printerAlert.getCondition(), printerAlert.getDestination(), false, false, "", 0, false));
        }
    }

    @Override
    public void removeAllAlerts() throws ConnectionException {
        ArrayList<PrinterAlert> arrayList = new ArrayList<PrinterAlert>();
        try {
            ProfileHelper.commitAlertsToProfile(this.pathToProfile, arrayList);
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }

    @Override
    public void downloadTtfFont(String string, String string2) throws ConnectionException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FontConverterZpl.saveAsTtfPrinterFont(string, (OutputStream)byteArrayOutputStream, string2);
        try {
            new ZipUtil(this.pathToProfile).addEntry(string2, byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }

    @Override
    public void downloadTteFont(String string, String string2) throws ConnectionException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FontConverterZpl.saveAsTtePrinterFont(string, (OutputStream)byteArrayOutputStream, string2);
        try {
            new ZipUtil(this.pathToProfile).addEntry(string2, byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }

    @Override
    public void downloadTtfFont(InputStream inputStream, String string) throws ConnectionException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FontConverterZpl.saveAsTtfPrinterFont(inputStream, (OutputStream)byteArrayOutputStream, string);
        try {
            new ZipUtil(this.pathToProfile).addEntry(string, byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }

    @Override
    public void downloadTteFont(InputStream inputStream, String string) throws ConnectionException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FontConverterZpl.saveAsTtePrinterFont(inputStream, (OutputStream)byteArrayOutputStream, string);
        try {
            new ZipUtil(this.pathToProfile).addEntry(string, byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }

    @Override
    public void sendFileContents(String string) throws IllegalStateException {
        throw new IllegalStateException("sendFileContents is not valid for profiles");
    }

    public void sendContents(String string, byte[] byArray) throws ConnectionException {
        try {
            new ZipUtil(this.pathToProfile).addEntry(string, byArray);
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }

    @Override
    public String[] retrieveFileNames() {
        List<String> list = new ZipUtil(this.pathToProfile).getEntryNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (ProfileHelper.isSpecialProfileFile(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public String[] retrieveFileNames(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            String[] stringArray2;
            for (String string : stringArray2 = this.retrieveFileNames()) {
                for (String string2 : stringArray) {
                    if (!string.toLowerCase().endsWith("." + string2.toLowerCase())) continue;
                    arrayList.add(string);
                }
            }
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public void storeFileOnPrinter(String string) throws ConnectionException, ZebraIllegalArgumentException {
        this.storeFileOnPrinter(string, FileUtilities.GetFileNameOnPrinter(string));
    }

    @Override
    public void storeFileOnPrinter(String string, String string2) throws ConnectionException {
        byte[] byArray = FileReader.toByteArray(string);
        this.storeFileOnPrinter(byArray, string2);
    }

    @Override
    public void storeFileOnPrinter(byte[] byArray, String string) throws ConnectionException {
        try {
            new ZipUtil(this.pathToProfile).addEntry(string, FileWrapper.wrapFileWithCisdfHeader(byArray, string));
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }

    @Override
    public void deleteFile(String string) throws ConnectionException {
        try {
            ProfileHelper.deleteFileFromProfile(this.pathToProfile, string);
        }
        catch (Exception exception) {
            throw new ConnectionException(exception.getLocalizedMessage());
        }
    }

    @Override
    public byte[] getObjectFromPrinter(String string) throws ZebraIllegalArgumentException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.getObjectFromPrinter(byteArrayOutputStream, string);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void getObjectFromPrinter(OutputStream outputStream, String string) throws ZebraIllegalArgumentException {
        try {
            byte[] byArray = null;
            byte[] byArray2 = null;
            try {
                byArray2 = new ZipUtil(this.pathToProfile).extractEntry(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ZebraIllegalArgumentException(fileNotFoundException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                throw new ZebraIllegalArgumentException(iOException.getLocalizedMessage());
            }
            if (FileWrapper.isHzoExtension(string.substring(string.lastIndexOf(46) + 1))) {
                FileWrapper.unwrapHZOResult(outputStream, string, new String(byArray2));
            } else {
                byArray = FileWrapper.stripOffCISDFWrapper(byArray2);
                outputStream.write(byArray);
            }
        }
        catch (IOException iOException) {
            throw new ZebraIllegalArgumentException(iOException.getLocalizedMessage());
        }
    }

    @Override
    public byte[] getObjectFromPrinterViaFtp(String string, String string2) throws ZebraIllegalArgumentException {
        throw new ZebraIllegalArgumentException("Cannot access a profile over FTP");
    }

    @Override
    public void getObjectFromPrinterViaFtp(OutputStream outputStream, String string, String string2) throws ConnectionException, ZebraIllegalArgumentException {
        throw new ZebraIllegalArgumentException("Cannot access a profile over FTP");
    }

    @Override
    public byte[] getPrinterDownloadableObjectFromPrinter(String string) throws ZebraIllegalArgumentException {
        try {
            return new ZipUtil(this.pathToProfile).extractEntry(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ZebraIllegalArgumentException(fileNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            throw new ZebraIllegalArgumentException(iOException.getLocalizedMessage());
        }
    }

    @Override
    public List<StorageInfo> getStorageInfo() throws ConnectionException {
        throw new ConnectionException("Storage info is not available for a profile");
    }

    @Override
    public void sendFileContents(String string, ProgressMonitor progressMonitor) {
        throw new IllegalStateException("sendFileContents is not valid for profiles");
    }

    @Override
    public List<PrinterObjectProperties> retrieveObjectsProperties() throws ZebraIllegalArgumentException {
        String[] stringArray = this.retrieveFileNames();
        ArrayList<PrinterObjectProperties> arrayList = new ArrayList<PrinterObjectProperties>();
        for (String string : stringArray) {
            String string2;
            PrinterFilePath printerFilePath = FileUtilities.parseDriveAndExtension(string);
            String string3 = printerFilePath.getDrive();
            if (string3.length() > 0 && !string3.endsWith(":")) {
                string3 = string3 + ":";
            }
            if ((string2 = printerFilePath.getExtension()).startsWith(".")) {
                string2 = string2.substring(1);
            }
            long l = 0L;
            try {
                l = new ZipUtil(this.pathToProfile).getEntryContents(string).length();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            arrayList.add(new PrinterFilePropertiesZpl(string3, printerFilePath.getFileName(), string2, l));
        }
        return arrayList;
    }

    @Override
    public Map<String, Setting> getAllSettings() throws SettingsException {
        return this.profileBasedSettingsList.getAllSettings();
    }

    @Override
    public void printImage(String string, int n, int n2) throws ConnectionException, IOException {
        throw new ConnectionException("Printing an image is not applicable to a profile.");
    }

    @Override
    public void printImage(String string, int n, int n2, int n3, int n4, boolean bl) throws ConnectionException, IOException {
        throw new ConnectionException("Printing an image is not applicable to a profile.");
    }

    @Override
    public void printImage(ZebraImageI zebraImageI, int n, int n2, int n3, int n4, boolean bl) throws ConnectionException {
        throw new ConnectionException("Printing an image is not applicable to a profile.");
    }

    @Override
    public void storeImage(String string, ZebraImageI zebraImageI, int n, int n2) throws ConnectionException, ZebraIllegalArgumentException {
        GraphicsConversionUtilZpl graphicsConversionUtilZpl = new GraphicsConversionUtilZpl();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            graphicsConversionUtilZpl.sendImageToStream(string, (ZebraImageInternal)zebraImageI, n, n2, byteArrayOutputStream);
            new ZipUtil(this.pathToProfile).addEntry(string, byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }

    @Override
    public void storeImage(String string, String string2, int n, int n2) throws ConnectionException, ZebraIllegalArgumentException, IOException {
        this.storeImage(string, ReflectionUtil.invokeZebraImageFactory_getImage(string2), n, n2);
    }

    public Setting getSetting(String string) throws SettingsException {
        return this.profileBasedSettingsList.getSetting(string);
    }

    public void setSetting(String string, Setting setting) throws SettingsException {
        this.profileBasedSettingsList.setSetting(string, setting);
    }

    public void setAllSettings(Map<String, Setting> map) throws SettingsException {
        this.profileBasedSettingsList.setAllSettings(map);
    }

    @Override
    public Map<String, String> processSettingsViaMap(Map<String, String> map) throws SettingsException, ConnectionException {
        return this.profileBasedSettingsList.processSettingsViaMap(map);
    }
}

