/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.Option;
import com.zebra.sdk.commandline.internal.OptionGroup;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.printer.NotALinkOsPrinterException;
import com.zebra.sdk.printer.PrinterUtil;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.util.internal.Range;

public class ConfigLabelCommand
extends Command {
    private static final Option CONFIG_OPTION = new Option("c", "config", "Print the default configuration label");
    private static final Option NETWORK_OPTION = new Option("n", "network", "Print the network configuration label");
    private static final Option FILE_OPTION = new Option("f", "files", "Print the directory listing");
    private static final Option ALL_OPTION = new Option("a", "all", "Print the default configuration, directory listing, and network configuration labels");
    private static final int PRINTER_INDEX = 0;

    public ConfigLabelCommand() {
        this.options.add(CONFIG_OPTION);
        this.options.add(NETWORK_OPTION);
        this.options.add(FILE_OPTION);
        this.options.add(ALL_OPTION);
        this.options.add(ZebraCommandConstants.DRIVER_OPTION);
        this.options.add(ZebraCommandConstants.TCP_OPTION);
        this.groups.add(new OptionGroup().createGroup(CONFIG_OPTION, NETWORK_OPTION, FILE_OPTION, ALL_OPTION));
        this.groups.add(ZebraCommandConstants.TCP_USB_GROUP);
    }

    @Override
    public String getCommandName() {
        return "config";
    }

    @Override
    public String getDescription() {
        return "Prints the configuration label.";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
        String string = parsedArguments.getArg(0);
        String string2 = this.getConnectionFromArgs(parsedArguments, string);
        if (parsedArguments.containsOption(NETWORK_OPTION)) {
            this.printNetworkConfigLabel(string, string2);
        } else if (parsedArguments.containsOption(FILE_OPTION)) {
            this.printDirectoryLabel(string, string2);
        } else if (parsedArguments.containsOption(ALL_OPTION)) {
            this.printDefaultConfigLabel(string, string2);
            this.printDirectoryLabel(string, string2);
            this.printNetworkConfigLabel(string, string2);
        } else {
            this.printDefaultConfigLabel(string, string2);
        }
    }

    private void printDefaultConfigLabel(String string, String string2) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        this.verboseFormatPrint("Printing default configuration label on %s%n", string);
        PrinterUtil.printConfigLabel(string2);
    }

    private void printDirectoryLabel(String string, String string2) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        this.verboseFormatPrint("Printing directory listing on %s%n", string);
        PrinterUtil.printDirectoryLabel(string2);
    }

    private void printNetworkConfigLabel(String string, String string2) throws ConnectionException, ZebraPrinterLanguageUnknownException, NotALinkOsPrinterException {
        this.verboseFormatPrint("Printing network configuration label on %s%n", string);
        PrinterUtil.printNetworkConfigLabel(string2);
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <printer> [<options>]%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.ONE_ARG_RANGE;
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Print a config label via ZDesigner Driver connected printer\n");
        stringBuilder.append(String.format("\t%s %s \"ZDesigner QLn320\" --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ZebraCommandConstants.DRIVER_OPTION.getLongName()));
        stringBuilder.append("Print directory listing on a printer\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), FILE_OPTION.getLongName()));
        stringBuilder.append("Print network configuration via port 6101\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4:6101 --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), NETWORK_OPTION.getLongName()));
        stringBuilder.append("Print all labels on a printer with verbose mode\n");
        stringBuilder.append(String.format("\t%s %s 1.2.3.4 --%s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ALL_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        stringBuilder.append("Print all labels on a printer with verbose mode via Driverless USB\n");
        stringBuilder.append(String.format("\t%s %s \"USB_DIRECT:\\\\?\\usb#vid_0a5f&pid_00f2#imz220#...\" --%s --%s%n", "java -jar ZSDK_API.jar", this.getCommandName(), ALL_OPTION.getLongName(), ZebraCommandConstants.VERBOSE_OPTION.getLongName()));
        return stringBuilder.toString();
    }
}

