/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.comm.internal;

import com.zebra.sdk.comm.ConnectionA;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.internal.LibUsbUtils;
import com.zebra.sdk.comm.internal.UsbConnectionI;
import com.zebra.sdk.comm.internal.UsbUtils;
import com.zebra.sdk.util.internal.StringUtilities;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Map;
import org.usb4java.BufferUtils;
import org.usb4java.ConfigDescriptor;
import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.EndpointDescriptor;
import org.usb4java.Interface;
import org.usb4java.InterfaceDescriptor;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class UsbConnectionLibUsb
extends ConnectionA
implements UsbConnectionI {
    private DeviceHandle deviceHandle = null;
    private Context context = null;
    protected String symbolicName = "";
    private Map<String, String> connectionAttributes;
    private byte IN_ENDPOINT = 0;
    private byte OUT_ENDPOINT = 0;
    private static final long CARD_PRINTER_WRITE_TIMEOUT = 10000L;
    protected long WRITE_TIMEOUT = 5000L;
    protected long READ_TIMEOUT = 300L;

    public UsbConnectionLibUsb(String string) throws ConnectionException {
        int n;
        this.symbolicName = string;
        if (this.context == null) {
            this.context = new Context();
        }
        if ((n = LibUsb.init((Context)this.context)) < 0) {
            throw new ConnectionException("Unable to initialize libusb: " + n);
        }
    }

    @Override
    public Map<String, String> loadDeviceMap() throws ConnectionException {
        this.connectionAttributes = LibUsbUtils.loadDeviceIdMap(this.symbolicName);
        return this.connectionAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ConnectionException {
        int n;
        if (this.isConnected) {
            return;
        }
        DeviceList deviceList = new DeviceList();
        if (this.deviceHandle == null) {
            this.deviceHandle = new DeviceHandle();
        }
        if ((n = LibUsb.getDeviceList((Context)this.context, (DeviceList)deviceList)) < 0) {
            LibUsbException libUsbException = new LibUsbException("Unable to get device list", n);
            throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
        }
        try {
            for (Device device : deviceList) {
                String string;
                if (!LibUsbUtils.isZebraDevice(device) || !(string = LibUsbUtils.getSymbolicName(device)).equals(this.symbolicName)) continue;
                this.loadPrinterEndpoints(device);
                n = LibUsb.open((Device)device, (DeviceHandle)this.deviceHandle);
                if (n >= 0) break;
                LibUsbException libUsbException = new LibUsbException("Unable to open device", n);
                throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
            }
            if (this.deviceHandle == null || this.deviceHandle.getPointer() == 0L) {
                throw new ConnectionException("Could not connect to device: " + this.symbolicName);
            }
            this.isConnected = true;
        }
        finally {
            LibUsb.freeDeviceList((DeviceList)deviceList, (boolean)true);
        }
        int n2 = 0;
        n = LibUsb.kernelDriverActive((DeviceHandle)this.deviceHandle, (int)n2);
        if (n != 0) {
            n = LibUsb.detachKernelDriver((DeviceHandle)this.deviceHandle, (int)n2);
        }
        if ((n = LibUsb.claimInterface((DeviceHandle)this.deviceHandle, (int)n2)) != 0) {
            Device device;
            device = new LibUsbException("Unable to claim interface", n);
            throw new ConnectionException(device.getLocalizedMessage(), (Throwable)device);
        }
    }

    private void loadPrinterEndpoints(Device device) throws ConnectionException {
        Interface[] interfaceArray;
        DeviceDescriptor deviceDescriptor = new DeviceDescriptor();
        int n = LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)deviceDescriptor);
        if (n < 0) {
            LibUsbException libUsbException = new LibUsbException("Unable to read device descriptor", n);
            throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
        }
        ConfigDescriptor configDescriptor = new ConfigDescriptor();
        for (byte by = 0; by < deviceDescriptor.bNumConfigurations(); by = (byte)(by + 1)) {
            n = LibUsb.getConfigDescriptor((Device)device, (byte)by, (ConfigDescriptor)configDescriptor);
        }
        if (n < 0) {
            LibUsbException libUsbException = new LibUsbException("Unable to read config descriptor", n);
            throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
        }
        for (Interface interface_ : interfaceArray = configDescriptor.iface()) {
            for (InterfaceDescriptor interfaceDescriptor : interface_.altsetting()) {
                for (EndpointDescriptor endpointDescriptor : interfaceDescriptor.endpoint()) {
                    byte by = endpointDescriptor.bEndpointAddress();
                    byte by2 = (byte)(by & 0xFFFFFF80);
                    if (by2 == 0) {
                        this.OUT_ENDPOINT = by;
                        continue;
                    }
                    this.IN_ENDPOINT = by;
                }
            }
        }
        LibUsb.freeConfigDescriptor((ConfigDescriptor)configDescriptor);
    }

    @Override
    public void close() throws ConnectionException {
        if (this.deviceHandle != null && this.deviceHandle.getPointer() > 0L) {
            LibUsbUtils.close(this.deviceHandle);
        }
        this.deviceHandle = null;
        this.isConnected = false;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws ConnectionException {
        ByteBuffer byteBuffer = BufferUtils.allocateByteBuffer((int)n2);
        byteBuffer.put(byArray, 0, n2);
        IntBuffer intBuffer = BufferUtils.allocateIntBuffer();
        long l = UsbUtils.isCardPrinter(this.connectionAttributes) ? 10000L : this.WRITE_TIMEOUT;
        int n3 = 0;
        do {
            int n4 = LibUsb.bulkTransfer((DeviceHandle)this.deviceHandle, (byte)this.OUT_ENDPOINT, (ByteBuffer)byteBuffer, (IntBuffer)intBuffer, (long)l);
            n3 = intBuffer.get();
            if (n4 == -7) {
                throw new ConnectionException("Error: write timeout");
            }
            if (n4 == 0) continue;
            LibUsbException libUsbException = new LibUsbException("Unable to send data", n4);
            throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
        } while (n3 < n2);
    }

    @Override
    public byte[] readFromPrinter() throws ConnectionException {
        int n = 1024;
        return this.nativeRead(n);
    }

    @Override
    public byte[] nativeRead(int n) throws ConnectionException {
        ByteBuffer byteBuffer = BufferUtils.allocateByteBuffer((int)n).order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = BufferUtils.allocateIntBuffer();
        long l = UsbUtils.isCardPrinter(this.connectionAttributes) ? (long)super.getMaxTimeoutForRead() : this.READ_TIMEOUT;
        boolean bl = UsbUtils.isCardPrinter(this.connectionAttributes);
        boolean bl2 = UsbUtils.isZMotifPrinter(this.connectionAttributes);
        int n2 = 0;
        do {
            int n3 = LibUsb.bulkTransfer((DeviceHandle)this.deviceHandle, (byte)this.IN_ENDPOINT, (ByteBuffer)byteBuffer, (IntBuffer)intBuffer, (long)l);
            n2 = intBuffer.get();
            intBuffer = BufferUtils.allocateIntBuffer();
            if (n3 == -7) {
                int n4 = n2;
                byteBuffer.clear();
                byteBuffer = BufferUtils.allocateByteBuffer((int)(n - n4)).order(ByteOrder.LITTLE_ENDIAN);
                continue;
            }
            if (n3 == 0) continue;
            LibUsbException libUsbException = new LibUsbException("Unable to read data", n3);
            throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
        } while (bl && (bl2 || n2 <= 0) && n2 < n);
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpConfigurationDescriptors(Device device, int n) throws ConnectionException {
        for (byte by = 0; by < n; by = (byte)(by + 1)) {
            ConfigDescriptor configDescriptor = new ConfigDescriptor();
            try {
                int n2 = LibUsb.getConfigDescriptor((Device)device, (byte)by, (ConfigDescriptor)configDescriptor);
                if (n2 >= 0) continue;
                LibUsbException libUsbException = new LibUsbException("Unable to read config descriptor", n2);
                throw new ConnectionException(libUsbException.getLocalizedMessage(), (Throwable)libUsbException);
            }
            finally {
                LibUsb.freeConfigDescriptor((ConfigDescriptor)configDescriptor);
            }
        }
    }

    @Override
    public String getSimpleConnectionName() {
        return null;
    }

    @Override
    public void setMaxTimeoutForRead(int n) {
        super.setMaxTimeoutForRead(n);
    }

    @Override
    public Map<String, String> getConnectionAttributes() {
        return this.connectionAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSerialNumber() {
        String string = this.connectionAttributes.get("SERIAL_NUMBER");
        if (!UsbUtils.isCardPrinter(this.connectionAttributes)) {
            try {
                String string2;
                this.open();
                this.write("! U1 getvar \"device.unique_id\"\r\n".getBytes());
                byte[] byArray = this.nativeRead(1024);
                if (byArray != null && (string2 = new String(byArray)) != null && !string2.isEmpty()) {
                    string = StringUtilities.stripQuotes(string2);
                    this.connectionAttributes.put("SERIAL_NUMBER", string);
                }
            }
            catch (ConnectionException connectionException) {
            }
            finally {
                try {
                    this.close();
                }
                catch (ConnectionException connectionException) {}
            }
        }
        return string;
    }
}

