/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.internal;

import com.zebra.sdk.comm.snmp.internal.Snmp;
import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.printer.discovery.DiscoveryHandler;
import com.zebra.sdk.printer.discovery.NetworkDiscoverer;
import com.zebra.sdk.settings.internal.SettingType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class NetworkUtil {
    private static final List<String> cardCmdIdValues = new ArrayList<String>(Arrays.asList("zmotif", "epcl", "epcl1", "epcl3"));

    public static void startSinglePrinterDiscovery(String string, DiscoveryHandler discoveryHandler) throws DiscoveryException {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        NetworkDiscoverer.findPrinters(discoveryHandler, linkedList);
    }

    public static Map<String, String> getIEEE1284DeviceId(String string) {
        Map<String, String> map = new HashMap<String, String>();
        try {
            Snmp snmp = new Snmp("public", "public", SettingType.STRING);
            String string2 = "1.3.6.1.4.1.2699.1.2.1.2.1.1.3.1";
            String string3 = snmp.get(string, string2);
            if (string3 != null && !string3.isEmpty()) {
                map = NetworkUtil.addDeviceIdArtributesToMap(string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    private static Map<String, String> addDeviceIdArtributesToMap(String string) {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray = string.split(";")) {
            String[] stringArray2 = string2.split(":");
            if (stringArray2.length <= 1) continue;
            String string3 = stringArray2[0];
            String string4 = stringArray2[1].trim();
            if (string3.equals("MANUFACTURER")) {
                hashMap.put("MFG", string4);
            }
            if (string3.equals("MFG")) {
                hashMap.put("MFG", string4);
            }
            if (string3.equals("MODEL")) {
                hashMap.put("MODEL", string4);
            }
            if (string3.equals("MDL")) {
                hashMap.put("MODEL", string4);
            }
            if (string3.equals("COMMAND SET")) {
                hashMap.put("CMD", string4);
            }
            if (string3.equals("CMD")) {
                hashMap.put("CMD", string4);
            }
            if (string3.equals("SERIAL NUMBER")) {
                hashMap.put("SERIAL_NUMBER", string4);
            }
            if (!string3.equals("SN")) continue;
            hashMap.put("SERIAL_NUMBER", string4);
        }
        return hashMap;
    }

    public static boolean isCardPrinter(String string) {
        boolean bl = false;
        try {
            Map<String, String> map;
            if (string != null && !string.isEmpty() && (map = NetworkUtil.getIEEE1284DeviceId(string)).size() > 0) {
                String string2;
                String string3 = "";
                if (map.containsKey("CMD")) {
                    string3 = map.get("CMD");
                }
                if (map.containsKey("MFG") && ((string2 = map.get("MFG").toLowerCase(Locale.US)).contains("card") || NetworkUtil.isCardPrinterCmdId(string3))) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static boolean isCardPrinterCmdId(String string) {
        boolean bl = false;
        if (string != null && !string.isEmpty() && cardCmdIdValues.contains(string.toLowerCase(Locale.US))) {
            bl = true;
        }
        return bl;
    }
}

