/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.fileConversion.internal;

import com.zebra.sdk.util.fileConversion.internal.DataFormatSpecifier;
import com.zebra.sdk.util.internal.ZPLUtilities;
import java.io.IOException;
import java.io.InputStream;

public class DZ_DataProviderStream
extends InputStream {
    InputStream sourceStream;
    String[] headerParts = new String[]{"", ""};
    int[] preReaderDataHeader = new int[5];
    int preReaderDataHeaderIndex = 0;
    private DataFormatSpecifier dataFormatSpecifier = DataFormatSpecifier.OTHER;

    public DZ_DataProviderStream(InputStream inputStream) throws IOException {
        this.sourceStream = inputStream;
        int n = 0;
        int n2 = 0;
        while (n != 2 && n2 != -1) {
            n2 = this.sourceStream.read();
            if (n2 == 44 || n2 == 31) {
                ++n;
                continue;
            }
            int n3 = n;
            this.headerParts[n3] = this.headerParts[n3] + (char)n2;
        }
        if (n != 2) {
            throw new IOException("Invalid ~DZ Header");
        }
        this.headerParts[0] = this.headerParts[0].replace(ZPLUtilities.ZPL_INTERNAL_COMMAND_PREFIX, "~").replace("~DZ", "").trim();
        for (int i = 0; i < this.preReaderDataHeader.length; ++i) {
            this.preReaderDataHeader[i] = inputStream.read();
        }
        this.setDataFormatSpecifier();
        if (this.isDataMimed()) {
            this.ignorePrereadData();
        }
    }

    private boolean isDataMimed() {
        return this.dataFormatSpecifier == DataFormatSpecifier.MIME_COMPRESSED || this.dataFormatSpecifier == DataFormatSpecifier.MIME_UNCOMPRESSED;
    }

    private void ignorePrereadData() {
        this.preReaderDataHeaderIndex = this.preReaderDataHeader.length;
    }

    private void setDataFormatSpecifier() {
        this.dataFormatSpecifier = this.isMimeUncompressed() ? DataFormatSpecifier.MIME_UNCOMPRESSED : (this.isMimeCompressed() ? DataFormatSpecifier.MIME_COMPRESSED : DataFormatSpecifier.RAW_BINARY);
    }

    private boolean isMimeUncompressed() {
        return new String(this.preReaderDataHeader, 0, this.preReaderDataHeader.length).equalsIgnoreCase(":B64:");
    }

    private boolean isMimeCompressed() {
        return new String(this.preReaderDataHeader, 0, this.preReaderDataHeader.length).equalsIgnoreCase(":Z64:");
    }

    @Override
    public int read() throws IOException {
        int n = -1;
        n = this.preReaderDataHeaderIndex < this.preReaderDataHeader.length ? this.preReaderDataHeader[this.preReaderDataHeaderIndex++] : this.sourceStream.read();
        return n;
    }

    public InputStream getSourceStream() {
        return this.sourceStream;
    }

    public String getFilenameOnPrinter() {
        return this.headerParts[0];
    }

    public int getTotalBytesInData() throws IOException {
        int n = -1;
        try {
            n = this.headerParts[1].isEmpty() ? -1 : Integer.parseInt(this.headerParts[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n < 0) {
            throw new IOException("Invalid ~DZ Header");
        }
        return n;
    }

    public DataFormatSpecifier getDataFormatSpecifier() {
        return this.dataFormatSpecifier;
    }
}

