/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.fileConversion.internal;

import com.zebra.sdk.util.fileConversion.internal.AsciiDecoderStream;
import com.zebra.sdk.util.fileConversion.internal.ColonSignifiesEndStream;
import com.zebra.sdk.util.fileConversion.internal.DYDataProviderStream;
import com.zebra.sdk.util.fileConversion.internal.DataFormatSpecifier;
import com.zebra.sdk.util.fileConversion.internal.GrfToPrinterPngConverterStream;
import com.zebra.sdk.util.fileConversion.internal.PrinterFileType;
import com.zebra.sdk.util.fileConversion.internal.PrinterPngToGrfConverterStream;
import com.zebra.sdk.util.fileConversion.internal.PrinterWrappingType;
import com.zebra.sdk.util.fileConversion.internal.ZebraImageHeaderPrependerStream;
import com.zebra.sdk.util.fileConversion.internal.ZplUnwrapperStreamBase;
import com.zebra.sdk.util.internal.Base64;
import com.zebra.sdk.util.internal.CustomGZIPInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DY_UnwrapperStream
extends ZplUnwrapperStreamBase {
    DY_SourceDataType dy_SourceDataType;

    public DY_UnwrapperStream(InputStream inputStream) throws IOException {
        InputStream inputStream2;
        if (inputStream == null) {
            throw new IOException("input stream is null");
        }
        DYDataProviderStream dYDataProviderStream = new DYDataProviderStream(inputStream);
        this.unwrappedType = PrinterFileType.getUnwrappedType("~DY_" + dYDataProviderStream.getFileExtensionCode());
        this.dy_SourceDataType = DY_SourceDataType.getSourceType(dYDataProviderStream.getFormatDownloadedInDataField());
        this.dataUnwrapperStream = inputStream2 = this.getDataDecodingStream(dYDataProviderStream);
        if (this.shouldPrependZebraImageHeader()) {
            this.dataUnwrapperStream = this.getImageStream(inputStream2, dYDataProviderStream.getBytesPerRow(), dYDataProviderStream.getTotalBytesInData());
        }
        this.fileNameOnPrinter = dYDataProviderStream.getFilenameOnPrinter();
    }

    private InputStream getDataDecodingStream(DYDataProviderStream dYDataProviderStream) throws IOException {
        InputStream inputStream = dYDataProviderStream;
        if (dYDataProviderStream.getDataFormatSpecifier() == DataFormatSpecifier.MIME_UNCOMPRESSED) {
            inputStream = new Base64.InputStream(new ColonSignifiesEndStream(dYDataProviderStream), 0);
        } else if (dYDataProviderStream.getDataFormatSpecifier() == DataFormatSpecifier.MIME_COMPRESSED) {
            inputStream = new CustomGZIPInputStream(new Base64.InputStream(new ColonSignifiesEndStream(dYDataProviderStream), 0));
        } else if (dYDataProviderStream.getDataFormatSpecifier() == DataFormatSpecifier.ASCII_HEX) {
            inputStream = new AsciiDecoderStream(dYDataProviderStream, dYDataProviderStream.getBytesPerRow());
        }
        return inputStream;
    }

    private InputStream getImageStream(InputStream inputStream, int n, int n2) throws IOException {
        ZebraImageHeaderPrependerStream zebraImageHeaderPrependerStream;
        InputStream inputStream2 = zebraImageHeaderPrependerStream = new ZebraImageHeaderPrependerStream(inputStream, n, n2);
        if (this.shouldConvertFromGrfToPng()) {
            inputStream2 = new GrfToPrinterPngConverterStream(zebraImageHeaderPrependerStream);
        } else if (this.shouldConvertFromPngToGrf()) {
            inputStream2 = new PrinterPngToGrfConverterStream(zebraImageHeaderPrependerStream);
        }
        return inputStream2;
    }

    private boolean shouldConvertFromGrfToPng() {
        return this.dy_SourceDataType == DY_SourceDataType.UNCOMPRESSED && this.unwrappedType == PrinterFileType.PRINTER_PNG;
    }

    private boolean shouldConvertFromPngToGrf() {
        return this.dy_SourceDataType == DY_SourceDataType.PNG && this.unwrappedType == PrinterFileType.PRINTER_GRF;
    }

    private boolean shouldPrependZebraImageHeader() {
        return this.unwrappedType == PrinterFileType.PRINTER_GRF || this.unwrappedType == PrinterFileType.PRINTER_PNG;
    }

    @Override
    protected PrinterWrappingType getTypeToUnwrap() {
        return PrinterWrappingType.DY;
    }

    static enum DY_SourceDataType {
        UNCOMPRESSED("A"),
        BINARY("B"),
        PNG("P");

        private String formatDownloadedInDataField;

        private DY_SourceDataType(String string2) {
            this.formatDownloadedInDataField = string2;
        }

        public static DY_SourceDataType getSourceType(String string) throws IOException {
            for (DY_SourceDataType dY_SourceDataType : DY_SourceDataType.values()) {
                if (!dY_SourceDataType.formatDownloadedInDataField.equalsIgnoreCase(string)) continue;
                return dY_SourceDataType;
            }
            throw new IOException("Invalid ~DY Header  --  Missing Format Downloaded In Data Field parameter");
        }
    }
}

