/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.fileConversion.internal;

import java.io.IOException;
import java.io.InputStream;

public class AsciiDecoderStream
extends InputStream {
    private InputStream sourceStream;
    private int rleRepeatCount = 0;
    private int rleRepeatChar = -1;
    private int nibbleCounter = 0;
    private int[] previousRow = null;
    private int previousRowIndex = -1;

    public AsciiDecoderStream(InputStream inputStream, int n) throws IOException {
        this.sourceStream = inputStream;
        this.previousRow = n < 0 ? new int[2] : new int[n * 2];
        this.previousRowIndex = this.previousRow.length;
    }

    @Override
    public int read() throws IOException {
        int n = this.getNextChar();
        this.saveCurrentNibble(n);
        int n2 = this.getNextChar();
        this.saveCurrentNibble(n2);
        if (n == -1 || n2 == -1) {
            return -1;
        }
        return (char)(AsciiDecoderStream.hexToInt(n) << 4 | AsciiDecoderStream.hexToInt(n2));
    }

    private void saveCurrentNibble(int n) {
        this.previousRow[this.nibbleCounter++ % this.previousRow.length] = n;
    }

    private int getNextChar() throws IOException {
        int n = -1;
        if (this.previousRowIndex < this.previousRow.length) {
            n = this.getPreviousRowNibbleAt(this.previousRowIndex);
        } else if (this.rleRepeatCount > 1) {
            --this.rleRepeatCount;
            n = this.rleRepeatChar;
        } else {
            this.rleRepeatCount = 0;
            int n2 = this.nibbleCounter % this.previousRow.length;
            do {
                if ((n = this.sourceStream.read()) == 44) {
                    this.fillRemainderOfRow(n2, '0');
                    n = this.getPreviousRowNibbleAt(n2);
                    continue;
                }
                if (n == 33) {
                    this.fillRemainderOfRow(n2, 'F');
                    n = this.getPreviousRowNibbleAt(n2);
                    continue;
                }
                if (n == 58) {
                    n = this.getPreviousRowNibbleAt(0);
                    continue;
                }
                if (n > 70 && n < 90) {
                    this.rleRepeatCount += n - 70;
                    continue;
                }
                if (n > 102 && n < 123) {
                    this.rleRepeatCount += (n - 102) * 20;
                    continue;
                }
                if (this.rleRepeatCount <= 0) continue;
                this.rleRepeatChar = n;
            } while (n != -1 && !this.isAsciiHex(n));
        }
        return n;
    }

    private int getPreviousRowNibbleAt(int n) {
        this.previousRowIndex = n;
        return this.previousRow[this.previousRowIndex++];
    }

    private void fillRemainderOfRow(int n, char c) {
        for (int i = n; i < this.previousRow.length; ++i) {
            this.previousRow[i] = c;
        }
    }

    private boolean isAsciiHex(int n) {
        try {
            AsciiDecoderStream.hexToInt(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    private static int hexToInt(int n) {
        if (97 <= n && n <= 102) {
            return n - 97 + 10;
        }
        if (65 <= n && n <= 70) {
            return n - 65 + 10;
        }
        if (48 <= n && n <= 57) {
            return n - 48;
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }
}

