/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.settings.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.settings.Setting;
import com.zebra.sdk.util.internal.JacksonObjectMapperFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;

public class SettingsBuilder {
    private Map<String, Setting> mySettingsMap;

    public SettingsBuilder(Map<String, Setting> map) {
        this.mySettingsMap = map;
    }

    public void parse(byte[] byArray) throws ZebraIllegalArgumentException {
        try {
            this.parseJsonToMap(new String(byArray, this.getDefaultCharset()));
        }
        catch (Exception exception) {
            try {
                this.parseJsonToMap(new String(byArray, "UTF-8"));
            }
            catch (Exception exception2) {
                throw new ZebraIllegalArgumentException(exception2.getLocalizedMessage());
            }
        }
    }

    protected Charset getDefaultCharset() {
        return Charset.defaultCharset();
    }

    private void parseJsonToMap(String string) throws IOException, JsonParseException, JsonMappingException {
        TypeReference<Map<String, Map<String, Setting>>> typeReference = new TypeReference<Map<String, Map<String, Setting>>>(){};
        string = this.escapeControlCharacters(string);
        Map map = (Map)JacksonObjectMapperFactory.getInstance().readValue(string, (TypeReference)typeReference);
        this.mySettingsMap.putAll((Map)map.get("allconfig"));
    }

    private String escapeControlCharacters(String string) {
        if (string != null) {
            string = string.replace("\\b", "\\\\b");
            string = string.replace("\\f", "\\\\f");
            string = string.replace("\\n", "\\\\n");
            string = string.replace("\\r", "\\\\r");
            string = string.replace("\\t", "\\\\t");
        }
        return string;
    }

    private String removeExtraEscaping(String string) {
        if (string != null) {
            string = string.replace("\\\\b", "\\b");
            string = string.replace("\\\\f", "\\f");
            string = string.replace("\\\\n", "\\n");
            string = string.replace("\\\\r", "\\r");
            string = string.replace("\\\\t", "\\t");
        }
        return string;
    }

    public String toAllconfigJson() throws JsonProcessingException {
        String string = JacksonObjectMapperFactory.getInstance().enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString(this.mySettingsMap);
        string = this.removeExtraEscaping(string);
        return "{ \"allconfig\":\n" + string + "}";
    }
}

