/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.settings.internal;

import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.ConnectionWithWriteLogging;
import com.zebra.sdk.comm.LogStreamException;
import com.zebra.sdk.comm.ResponseValidator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PrinterlessConnection
implements ConnectionWithWriteLogging {
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private byte[] dataToReturnOnEveryRead = null;
    private OutputStream myWriteLogStream;

    public PrinterlessConnection() {
    }

    public PrinterlessConnection(byte[] byArray) {
        this.dataToReturnOnEveryRead = byArray;
    }

    @Override
    public void open() throws ConnectionException {
    }

    @Override
    public void close() throws ConnectionException {
    }

    @Override
    public void write(byte[] byArray) throws ConnectionException {
        this.write(byArray, 0, byArray.length);
        this.writeToLogStream(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws ConnectionException {
        this.baos.write(byArray, n, n2);
        this.writeToLogStream(byArray, n, n2);
    }

    @Override
    public byte[] read() throws ConnectionException {
        byte[] byArray = null;
        if (this.dataToReturnOnEveryRead != null) {
            byArray = this.dataToReturnOnEveryRead;
            this.dataToReturnOnEveryRead = null;
        }
        return byArray;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public int bytesAvailable() throws ConnectionException {
        if (this.dataToReturnOnEveryRead != null) {
            return this.dataToReturnOnEveryRead.length;
        }
        return 0;
    }

    @Override
    public void waitForData(int n) throws ConnectionException {
    }

    @Override
    public int getMaxTimeoutForRead() {
        return 10;
    }

    @Override
    public int getTimeToWaitForMoreData() {
        return 10;
    }

    public String getStuffWrittenOnConnection() {
        return this.baos.toString();
    }

    @Override
    public byte[] sendAndWaitForResponse(byte[] byArray, int n, int n2, String string) throws ConnectionException {
        this.write(byArray, 0, byArray.length);
        return this.read();
    }

    @Override
    public byte[] sendAndWaitForValidResponse(byte[] byArray, int n, int n2, ResponseValidator responseValidator) throws ConnectionException {
        this.write(byArray, 0, byArray.length);
        return this.read();
    }

    @Override
    public void sendAndWaitForValidResponse(OutputStream outputStream, InputStream inputStream, int n, int n2, ResponseValidator responseValidator) throws ConnectionException {
    }

    @Override
    public void setMaxTimeoutForRead(int n) {
    }

    @Override
    public void setTimeToWaitForMoreData(int n) {
    }

    @Override
    public void write(InputStream inputStream) throws ConnectionException {
    }

    @Override
    public void read(OutputStream outputStream) throws ConnectionException {
    }

    @Override
    public int readChar() throws ConnectionException {
        return -1;
    }

    @Override
    public void sendAndWaitForResponse(OutputStream outputStream, InputStream inputStream, int n, int n2, String string) throws ConnectionException {
        this.write(inputStream);
    }

    @Override
    public ConnectionReestablisher getConnectionReestablisher(long l) throws ConnectionException {
        return null;
    }

    @Override
    public String getSimpleConnectionName() {
        return null;
    }

    @Override
    public void addWriteLogStream(OutputStream outputStream) {
        this.myWriteLogStream = outputStream;
    }

    private void writeToLogStream(byte[] byArray, int n, int n2) throws LogStreamException {
        if (null != this.myWriteLogStream) {
            try {
                this.myWriteLogStream.write(byArray, n, n2);
            }
            catch (IOException iOException) {
                throw new LogStreamException("Error writing to log: " + iOException.getLocalizedMessage());
            }
        }
    }
}

