/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.remote.comm.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.ConnectionReestablisher;
import com.zebra.sdk.comm.internal.ConnectionReestablisherBase;
import com.zebra.sdk.printer.PrinterReconnectionHandler;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.ZebraPrinterFactory;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.remote.comm.RemoteConnection;
import com.zebra.sdk.util.internal.Sleeper;
import java.util.concurrent.TimeoutException;

public class RemoteConnectionReestablisher
extends ConnectionReestablisherBase
implements ConnectionReestablisher {
    protected static final int POWER_DOWN_DELAY = 5000;

    public RemoteConnectionReestablisher(Connection connection, long l) {
        super(connection, l);
    }

    protected String remoteConnectionSpecificWaitForPrinterToComeOnlineViaSgdAndGetFwVer(Connection connection) throws TimeoutException {
        this.startTime = System.currentTimeMillis();
        while (true) {
            try {
                connection.open();
                String string = SGD.GET("appl.name", connection);
                if (string == null || string.trim().isEmpty()) {
                    throw new ConnectionException("Printer is not responding");
                }
                string = SGD.GET("appl.name", connection);
                return string;
            }
            catch (ConnectionException connectionException) {
                try {
                    connection.close();
                }
                catch (ConnectionException connectionException2) {
                    // empty catch block
                }
                Sleeper.sleep(2500L);
                this.timeoutCheck();
                continue;
            }
            break;
        }
    }

    @Override
    public void reestablishConnection(PrinterReconnectionHandler printerReconnectionHandler) throws DiscoveryException, ConnectionException, TimeoutException, ZebraPrinterLanguageUnknownException {
        RemoteConnection remoteConnection = (RemoteConnection)this.zebraPrinterConnection;
        int n = remoteConnection.getRmiServerPort();
        String string = remoteConnection.getUniqueId();
        int n2 = remoteConnection.getMaxTimeoutForRead();
        int n3 = remoteConnection.getTimeToWaitForMoreData();
        RemoteConnection remoteConnection2 = new RemoteConnection(string, n, n2, n3);
        Sleeper.sleep(5000L);
        String string2 = this.remoteConnectionSpecificWaitForPrinterToComeOnlineViaSgdAndGetFwVer(remoteConnection2);
        ZebraPrinterLinkOs zebraPrinterLinkOs = ZebraPrinterFactory.createLinkOsPrinter(ZebraPrinterFactory.getInstance(remoteConnection2));
        printerReconnectionHandler.printerOnline(zebraPrinterLinkOs, string2);
    }
}

