/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.operations.internal.PrinterOperationBase;
import com.zebra.sdk.settings.SettingsException;
import com.zebra.sdk.settings.internal.ZebraSettingsListFromConnection;
import java.util.Map;

public class SettingsUpdaterOperation
extends PrinterOperationBase<Void> {
    private static final long serialVersionUID = 561030993363812422L;
    private Map<String, String> settingsToSet;

    public SettingsUpdaterOperation(Connection connection, Map<String, String> map, PrinterLanguage printerLanguage) {
        super(connection, printerLanguage);
        this.settingsToSet = map;
    }

    @Override
    public Void execute() throws ConnectionException {
        this.selectStatusChannelIfOpen();
        this.isOkToProceed();
        try {
            ZebraSettingsListFromConnection zebraSettingsListFromConnection = new ZebraSettingsListFromConnection(this.connection);
            zebraSettingsListFromConnection.setSettings(this.settingsToSet);
        }
        catch (SettingsException settingsException) {
            throw new ConnectionException(settingsException.getLocalizedMessage());
        }
        return null;
    }

    public Map<String, String> process() throws ConnectionException {
        this.selectStatusChannelIfOpen();
        this.isOkToProceed();
        Map<String, String> map = null;
        try {
            ZebraSettingsListFromConnection zebraSettingsListFromConnection = new ZebraSettingsListFromConnection(this.connection);
            map = zebraSettingsListFromConnection.processSettingsViaMap(this.settingsToSet);
        }
        catch (SettingsException settingsException) {
            throw new ConnectionException(settingsException.getLocalizedMessage());
        }
        return map;
    }

    private void isOkToProceed() throws ConnectionException {
        if (this.isPrintingChannelInLineMode()) {
            throw new ConnectionException("Cannot update settings over printing channel when in line mode");
        }
    }
}

