/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.operations.internal.PrinterOperationBase;
import com.zebra.sdk.settings.internal.JsonHelper;
import com.zebra.sdk.settings.internal.JsonValidator;

public class SendJsonOperation
extends PrinterOperationBase<String> {
    String jsonDataToSend;
    private static final long serialVersionUID = -898265088329695L;

    public SendJsonOperation(Connection connection, PrinterLanguage printerLanguage, String string) {
        super(connection, printerLanguage);
        this.jsonDataToSend = string;
    }

    @Override
    public String execute() throws ConnectionException {
        if (!JsonHelper.isValidJson(this.jsonDataToSend)) {
            throw new ConnectionException("Invalid JSON request.");
        }
        this.selectStatusChannelIfOpen();
        if (this.isPrintingChannelInLineMode()) {
            throw new ConnectionException("Cannot send JSON over raw port when printer is in line print mode.");
        }
        return new String(this.connection.sendAndWaitForValidResponse(this.jsonDataToSend.getBytes(), this.connection.getMaxTimeoutForRead(), this.connection.getTimeToWaitForMoreData(), new JsonValidator()));
    }
}

