/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.IpAddressable;
import com.zebra.sdk.comm.internal.ConnectionAttributeProvider;
import com.zebra.sdk.comm.internal.ConnectionAttributes;
import com.zebra.sdk.comm.snmp.internal.OidNotFoundException;
import com.zebra.sdk.comm.snmp.internal.SnmpGetNext;
import com.zebra.sdk.comm.snmp.internal.SnmpPreferences;
import com.zebra.sdk.comm.snmp.internal.SnmpV1;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.TcpPortStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortStatus {
    private static final String PORT_STATUS_OID = "1.3.6.1.2.1.6.13.1.1";

    private PortStatus() {
    }

    public static List<TcpPortStatus> getPortStatus(Connection connection, String string) throws ConnectionException {
        ArrayList<TcpPortStatus> arrayList;
        try {
            arrayList = PortStatus.getPortStatusViaSnmp(connection, string);
        }
        catch (ConnectionException connectionException) {
            arrayList = PortStatus.getPortStatusViaSGD(connection);
        }
        return arrayList;
    }

    private static ArrayList<TcpPortStatus> getPortStatusViaSnmp(Connection connection, String string) throws ConnectionException {
        ArrayList<TcpPortStatus> arrayList = new ArrayList<TcpPortStatus>();
        if (!(connection instanceof IpAddressable)) {
            throw new ConnectionException("Connection does not support SNMP");
        }
        Pattern pattern = Pattern.compile("1.3.6.1.2.1.6.13.1.1.([0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}).([0-9]{1,5}).([0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}).([0-9]{1,5})");
        String string2 = PORT_STATUS_OID;
        String string3 = "KNOWN";
        ConnectionAttributes connectionAttributes = new ConnectionAttributeProvider().getAttributes(connection);
        connectionAttributes.snmpGetCommunityName = string;
        String string4 = ((IpAddressable)((Object)connection)).getAddress();
        SnmpV1 snmpV1 = null;
        try {
            snmpV1 = new SnmpGetNext(string4, new SnmpPreferences(connectionAttributes));
            while (!string3.equals("UNKNOWN")) {
                ((SnmpGetNext)snmpV1).init(string2);
                snmpV1.sendRequest();
                snmpV1.getPdu().waitForSelf();
                string2 = (String)snmpV1.getReturnOid();
                Matcher matcher = pattern.matcher(string2);
                String string5 = snmpV1.getReturnValue().toString();
                string3 = PortStatus.lookupStatus(string5);
                if (!matcher.find()) continue;
                String string6 = matcher.group(2);
                String string7 = matcher.group(3);
                String string8 = matcher.group(4);
                arrayList.add(new TcpPortStatus(string6, PortStatus.lookupType(string6), string7, string8, string3));
            }
        }
        catch (OidNotFoundException oidNotFoundException) {
            throw new ConnectionException(oidNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getMessage());
        }
        finally {
            if (snmpV1 != null) {
                snmpV1.destroy();
            }
        }
        return arrayList;
    }

    private static ArrayList<TcpPortStatus> getPortStatusViaSGD(Connection connection) throws ConnectionException {
        ArrayList<TcpPortStatus> arrayList = new ArrayList<TcpPortStatus>();
        String[] stringArray = SGD.GET("ip.netstat", connection).split("\r\n");
        if (stringArray.length <= 2) {
            throw new ConnectionException("Port status could not be obtained.");
        }
        for (int i = 2; i < stringArray.length; ++i) {
            String string;
            String[] stringArray2 = stringArray[i].split("\\s+");
            if (stringArray2.length <= 4 || !stringArray2[0].equals("tcp")) continue;
            String string2 = stringArray2.length > 5 ? stringArray2[5] : "";
            String string3 = stringArray2[3].substring(stringArray2[3].lastIndexOf(46) + 1);
            String string4 = stringArray2[4].substring(0, stringArray2[4].lastIndexOf(46));
            if (string4.equals("*")) {
                string4 = "0.0.0.0";
            }
            if ((string = stringArray2[4].substring(stringArray2[4].lastIndexOf(46) + 1)).equals("*")) {
                string = "0";
            }
            arrayList.add(new TcpPortStatus(string3, PortStatus.lookupType(string3), string4, string, string2));
        }
        Collections.sort(arrayList, new Comparator<TcpPortStatus>(){

            @Override
            public int compare(TcpPortStatus tcpPortStatus, TcpPortStatus tcpPortStatus2) {
                int n;
                int n2;
                int n3 = Integer.parseInt(tcpPortStatus.getPrinterPort());
                if (n3 < (n2 = Integer.parseInt(tcpPortStatus2.getPrinterPort()))) {
                    return -1;
                }
                if (n3 > n2) {
                    return 1;
                }
                int n4 = Integer.parseInt(tcpPortStatus.getRemotePort());
                if (n4 < (n = Integer.parseInt(tcpPortStatus2.getRemotePort()))) {
                    return -1;
                }
                if (n4 > n) {
                    return 1;
                }
                return 0;
            }
        });
        return arrayList;
    }

    private static String lookupType(String string) {
        String string2 = "";
        try {
            int n = Integer.parseInt(string);
            switch (n) {
                case 20: {
                    string2 = string2 + "FTP";
                    break;
                }
                case 21: {
                    string2 = string2 + "FTP";
                    break;
                }
                case 23: {
                    string2 = string2 + "Telnet";
                    break;
                }
                case 25: {
                    string2 = string2 + "SMTP";
                    break;
                }
                case 80: {
                    string2 = string2 + "HTTP";
                    break;
                }
                case 110: {
                    string2 = string2 + "POP3";
                    break;
                }
                case 515: {
                    string2 = string2 + "LPD";
                    break;
                }
                case 631: {
                    string2 = string2 + "IPP";
                    break;
                }
                case 6101: {
                    string2 = string2 + "RAW";
                }
                default: {
                    if (n >= 9100 && n <= 9112) {
                        string2 = string2 + "RAW";
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private static String lookupStatus(String string) {
        String string2 = "UNKNOWN";
        try {
            switch (Integer.parseInt(string)) {
                case 1: {
                    string2 = "CLOSED";
                    break;
                }
                case 2: {
                    string2 = "LISTEN";
                    break;
                }
                case 3: {
                    string2 = "SYN_SENT";
                    break;
                }
                case 4: {
                    string2 = "SYN_RCVD";
                    break;
                }
                case 5: {
                    string2 = "ESTABLISHED";
                    break;
                }
                case 6: {
                    string2 = "FIN_WAIT_1";
                    break;
                }
                case 7: {
                    string2 = "FIN_WAIT_2";
                    break;
                }
                case 8: {
                    string2 = "CLOSED_WAIT";
                    break;
                }
                case 9: {
                    string2 = "CLOSING";
                    break;
                }
                case 10: {
                    string2 = "LAST_ACK";
                    break;
                }
                case 11: {
                    string2 = "TIME_WAIT";
                    break;
                }
                default: {
                    string2 = "UNKNOWN";
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }
}

