/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.graphics.ZebraImageI;
import com.zebra.sdk.graphics.internal.CompressedBitmapOutputStreamZpl;
import com.zebra.sdk.graphics.internal.DitheredImageProvider;
import com.zebra.sdk.graphics.internal.ZebraImageInternal;
import com.zebra.sdk.printer.internal.GraphicsConversionUtilZpl;
import com.zebra.sdk.printer.internal.GraphicsUtilA;
import com.zebra.sdk.printer.internal.PrinterConnectionOutputStream;
import com.zebra.sdk.util.internal.ZPLUtilities;
import java.io.IOException;
import java.io.OutputStream;

public class GraphicsUtilZpl
extends GraphicsUtilA {
    protected Connection printerConnection;

    public GraphicsUtilZpl(Connection connection) {
        this.printerConnection = connection;
    }

    @Override
    public void printImage(ZebraImageI zebraImageI, int n, int n2, int n3, int n4, boolean bl) throws ConnectionException {
        ZebraImageInternal zebraImageInternal = this.scaleImage(n3, n4, (ZebraImageInternal)zebraImageI);
        int n5 = (zebraImageInternal.getWidth() + 7) / 8;
        int n6 = n5 * zebraImageInternal.getHeight();
        String string = this.getBodyHeader(n, n2, bl, n5, n6);
        String string2 = ZPLUtilities.replaceAllWithInternalCharacters(string);
        this.printerConnection.write(string2.getBytes());
        PrinterConnectionOutputStream printerConnectionOutputStream = new PrinterConnectionOutputStream(this.printerConnection);
        CompressedBitmapOutputStreamZpl compressedBitmapOutputStreamZpl = new CompressedBitmapOutputStreamZpl(printerConnectionOutputStream);
        try {
            DitheredImageProvider.getDitheredImage(zebraImageInternal, compressedBitmapOutputStreamZpl);
            ((OutputStream)compressedBitmapOutputStreamZpl).close();
            printerConnectionOutputStream.close();
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getMessage());
        }
        if (!bl) {
            String string3 = ZPLUtilities.decorateWithFormatPrefix("^XZ");
            this.printerConnection.write(string3.getBytes());
        }
    }

    private String getBodyHeader(int n, int n2, boolean bl, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("^FO");
        stringBuffer.append(n);
        stringBuffer.append(",");
        stringBuffer.append(n2);
        stringBuffer.append("^GFA");
        stringBuffer.append(",");
        stringBuffer.append(n4);
        stringBuffer.append(",");
        stringBuffer.append(n4);
        stringBuffer.append(",");
        stringBuffer.append(n3);
        stringBuffer.append(",");
        String string = stringBuffer.toString();
        if (!bl) {
            string = "^XA" + string;
        }
        return string;
    }

    @Override
    public void storeImage(String string, ZebraImageI zebraImageI, int n, int n2) throws ConnectionException, ZebraIllegalArgumentException {
        GraphicsConversionUtilZpl graphicsConversionUtilZpl = new GraphicsConversionUtilZpl();
        PrinterConnectionOutputStream printerConnectionOutputStream = new PrinterConnectionOutputStream(this.printerConnection);
        try {
            graphicsConversionUtilZpl.sendImageToStream(string, (ZebraImageInternal)zebraImageI, n, n2, printerConnectionOutputStream);
        }
        catch (IOException iOException) {
            throw new ConnectionException(iOException.getLocalizedMessage());
        }
    }
}

