/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.TcpConnection;
import com.zebra.sdk.comm.internal.FTP;
import com.zebra.sdk.comm.internal.PrinterCommandImpl;
import com.zebra.sdk.device.FileUtilLinkOs;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.StorageInfo;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.internal.MultipartFormReceiverStream;
import com.zebra.sdk.printer.operations.internal.FileStorer;
import com.zebra.sdk.printer.operations.internal.ObjectGrabberOperation;
import com.zebra.sdk.printer.operations.internal.StorageInfoGrabber;
import com.zebra.sdk.util.fileConversion.internal.DZ_UnwrapperStream;
import com.zebra.sdk.util.fileConversion.internal.HzoToDzConverterStream;
import com.zebra.sdk.util.fileConversion.internal.MPF_UnwrapperStream;
import com.zebra.sdk.util.fileConversion.internal.StreamDecoratorBase;
import com.zebra.sdk.util.internal.FileReader;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.FileWrapper;
import com.zebra.sdk.util.internal.PrinterFileDescriptor;
import com.zebra.sdk.util.internal.PrinterFileMetadata;
import com.zebra.sdk.util.internal.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FileUtilLinkOsImpl
implements FileUtilLinkOs {
    private ZebraPrinterLinkOs zebraPrinterLinkOs;
    private static final Set<String> validExtensionsToGetObjectFromPrinter = new HashSet<String>(Arrays.asList("FNT", "ZPL", "GRF", "DAT", "BAS", "STO", "PNG", "LBL", "TTF", "PCX", "BMP", "IMG", "TTE", "WML", "CSV", "HTM", "BAE", "TXT"));

    public FileUtilLinkOsImpl(ZebraPrinterLinkOs zebraPrinterLinkOs) {
        this.zebraPrinterLinkOs = zebraPrinterLinkOs;
    }

    @Override
    public List<StorageInfo> getStorageInfo() throws ConnectionException {
        return new StorageInfoGrabber(this.zebraPrinterLinkOs.getConnection(), this.zebraPrinterLinkOs.getPrinterControlLanguage(), this.zebraPrinterLinkOs.getLinkOsInformation()).execute();
    }

    @Override
    public void storeFileOnPrinter(String string) throws ConnectionException, IOException, ZebraIllegalArgumentException {
        this.storeFileOnPrinter(string, FileUtilities.GetFileNameOnPrinter(string));
    }

    @Override
    public void storeFileOnPrinter(String string, String string2) throws ConnectionException, IOException, ZebraIllegalArgumentException {
        this.storeFileOnPrinter(FileReader.toByteArray(string), string2);
    }

    @Override
    public void storeFileOnPrinter(byte[] byArray, String string) throws ConnectionException, ZebraIllegalArgumentException {
        if (byArray == null) {
            throw new ZebraIllegalArgumentException("file not found.");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PrinterFileMetadata printerFileMetadata = null;
        try {
            printerFileMetadata = new PrinterFileMetadata(byteArrayInputStream);
            ((InputStream)byteArrayInputStream).reset();
        }
        catch (IOException iOException) {
            throw new ZebraIllegalArgumentException(iOException.getLocalizedMessage());
        }
        ArrayList<PrinterFileDescriptor> arrayList = new ArrayList<PrinterFileDescriptor>();
        PrinterFileDescriptor printerFileDescriptor = new PrinterFileDescriptor(byteArrayInputStream, string, printerFileMetadata);
        arrayList.add(printerFileDescriptor);
        FileStorer fileStorer = new FileStorer(arrayList, this.zebraPrinterLinkOs.getConnection(), this.zebraPrinterLinkOs.getPrinterControlLanguage(), this.zebraPrinterLinkOs.getLinkOsInformation());
        fileStorer.execute();
    }

    @Override
    public void deleteFile(String string) throws ConnectionException {
        SGD.SET("file.delete", string, this.zebraPrinterLinkOs.getConnection());
    }

    @Override
    public byte[] getObjectFromPrinter(String string) throws ConnectionException, ZebraIllegalArgumentException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.getObjectFromPrinter(byteArrayOutputStream, string);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void getObjectFromPrinter(OutputStream outputStream, String string) throws ConnectionException, ZebraIllegalArgumentException {
        InputStream inputStream = new ObjectGrabberOperation(string, this.zebraPrinterLinkOs.getConnection(), this.zebraPrinterLinkOs.getPrinterControlLanguage(), this.zebraPrinterLinkOs.getLinkOsInformation()).execute();
        HzoToDzConverterStream hzoToDzConverterStream = null;
        StreamDecoratorBase streamDecoratorBase = null;
        try {
            block9: {
                block8: {
                    block7: {
                        if (!(inputStream instanceof MultipartFormReceiverStream)) break block7;
                        streamDecoratorBase = new MPF_UnwrapperStream(inputStream);
                        break block8;
                    }
                    if (FileWrapper.isHzoExtension(string.substring(string.lastIndexOf(46) + 1))) {
                        hzoToDzConverterStream = new HzoToDzConverterStream(inputStream);
                        streamDecoratorBase = new DZ_UnwrapperStream(hzoToDzConverterStream);
                    }
                    break block9;
                }
                this.copyInputStreamToOutputStream(streamDecoratorBase, outputStream);
                return;
            }
            if (!this.validExtension(string)) throw new ZebraIllegalArgumentException("Invalid extension, cannot retrieve file type");
            this.retrieveFileViaFileTypeSgdCommand(outputStream, string);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        catch (IOException iOException) {
            if (!iOException.getLocalizedMessage().equals("File not found")) throw new ConnectionException(iOException.getLocalizedMessage());
            throw new ZebraIllegalArgumentException(iOException.getLocalizedMessage());
        }
        IOUtils.closeQuietly((InputStream)hzoToDzConverterStream);
        IOUtils.closeQuietly((InputStream)streamDecoratorBase);
        return;
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly(hzoToDzConverterStream);
            IOUtils.closeQuietly((InputStream)streamDecoratorBase);
        }
    }

    @Override
    public byte[] getObjectFromPrinterViaFtp(String string, String string2) throws ConnectionException, ZebraIllegalArgumentException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.getObjectFromPrinterViaFtp(byteArrayOutputStream, string, string2);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void getObjectFromPrinterViaFtp(OutputStream outputStream, String string, String string2) throws ConnectionException, ZebraIllegalArgumentException {
        if (!this.validExtension(string)) {
            throw new ZebraIllegalArgumentException("Invalid extension, cannot retrieve file type");
        }
        this.getFileOverFtp(outputStream, string, string2);
    }

    private boolean validExtension(String string) {
        return validExtensionsToGetObjectFromPrinter.contains(string.substring(string.lastIndexOf(46) + 1));
    }

    private void getFileOverFtp(OutputStream outputStream, String string, String string2) throws ConnectionException {
        Connection connection = this.zebraPrinterLinkOs.getConnection();
        if (connection instanceof TcpConnection) {
            FTP fTP = new FTP(((TcpConnection)connection).getAddress(), null, string2);
            fTP.getFile(outputStream, string);
        } else if (connection instanceof MultichannelConnection && ((MultichannelConnection)connection).getPrintingChannel() instanceof TcpConnection) {
            MultichannelConnection multichannelConnection = (MultichannelConnection)connection;
            TcpConnection tcpConnection = (TcpConnection)multichannelConnection.getPrintingChannel();
            FTP fTP = new FTP(tcpConnection.getAddress(), null, string2);
            fTP.getFile(outputStream, string);
        } else {
            throw new ConnectionException("Must be a TCP connected printer to tranfer files");
        }
    }

    @Override
    public byte[] getPrinterDownloadableObjectFromPrinter(String string) throws ConnectionException, ZebraIllegalArgumentException {
        byte[] byArray;
        MPF_UnwrapperStream mPF_UnwrapperStream;
        InputStream inputStream;
        block8: {
            ByteArrayOutputStream byteArrayOutputStream;
            block7: {
                if (!this.validExtension(string)) {
                    throw new ZebraIllegalArgumentException("Invalid extension, cannot retrieve file type");
                }
                inputStream = new ObjectGrabberOperation(string, this.zebraPrinterLinkOs.getConnection(), this.zebraPrinterLinkOs.getPrinterControlLanguage(), this.zebraPrinterLinkOs.getLinkOsInformation()).execute();
                mPF_UnwrapperStream = null;
                byteArrayOutputStream = new ByteArrayOutputStream();
                if (!(inputStream instanceof MultipartFormReceiverStream)) break block7;
                mPF_UnwrapperStream = new MPF_UnwrapperStream(inputStream);
                this.copyInputStreamToOutputStream(mPF_UnwrapperStream, byteArrayOutputStream);
                byte[] byArray2 = FileWrapper.wrapFile(byteArrayOutputStream.toByteArray(), string, false, false).getBytes();
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((InputStream)mPF_UnwrapperStream);
                return byArray2;
            }
            if (!FileWrapper.isHzoExtension(string.substring(string.lastIndexOf(46) + 1))) break block8;
            this.copyInputStreamToOutputStream(inputStream, byteArrayOutputStream);
            byte[] byArray3 = this.parseHzo(string, new ByteArrayInputStream(byteArrayOutputStream.toByteArray())).getBytes();
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((InputStream)mPF_UnwrapperStream);
            return byArray3;
        }
        try {
            byte[] byArray4 = this.retrieveFileViaFileTypeSgdCommand(string);
            byArray = FileWrapper.wrapFileWithCisdfHeader(byArray4, string);
        }
        catch (IOException iOException) {
            try {
                throw new ConnectionException(iOException.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(mPF_UnwrapperStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((InputStream)mPF_UnwrapperStream);
        return byArray;
    }

    private byte[] retrieveFileViaFileTypeSgdCommand(String string) throws ConnectionException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.retrieveFileViaFileTypeSgdCommand(byteArrayOutputStream, string);
        return byteArrayOutputStream.toByteArray();
    }

    private void retrieveFileViaFileTypeSgdCommand(OutputStream outputStream, String string) throws ConnectionException {
        String string2 = "! U1 do \"file.type\" \"" + string + "\"" + "\r\n";
        PrinterCommandImpl printerCommandImpl = new PrinterCommandImpl(string2);
        Connection connection = this.zebraPrinterLinkOs.getConnection();
        printerCommandImpl.sendAndWaitForResponse(outputStream, connection, connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData(), null);
    }

    private String parseHzo(String string, ByteArrayInputStream byteArrayInputStream) throws ZebraIllegalArgumentException {
        try {
            return XmlUtil.getTextContent(this.getObjectData(string, byteArrayInputStream), "");
        }
        catch (Exception exception) {
            throw new ZebraIllegalArgumentException(exception.getLocalizedMessage());
        }
    }

    private Node getObjectData(String string, ByteArrayInputStream byteArrayInputStream) throws SAXException, IOException, ParserConfigurationException, ZebraIllegalArgumentException {
        return XmlUtil.getDataAtNamedNode(byteArrayInputStream, "OBJECT-DATA", string);
    }

    private void copyInputStreamToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException, ZebraIllegalArgumentException {
        int n = inputStream.read();
        if (n == -1) {
            throw new ZebraIllegalArgumentException("Invalid extension or file not found");
        }
        while (n != -1) {
            outputStream.write(n);
            n = inputStream.read();
        }
    }
}

