/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.commandline.commands.internal;

import com.zebra.sdk.commandline.commands.internal.Command;
import com.zebra.sdk.commandline.internal.ParsedArguments;
import com.zebra.sdk.commandline.internal.ZebraCommandConstants;
import com.zebra.sdk.commandline.internal.ZebraCommandLineApp;
import com.zebra.sdk.util.internal.Range;

public class HelpCommand
extends Command {
    @Override
    public String getCommandName() {
        return "help";
    }

    @Override
    public String getDescription() {
        return "Get information about other commands";
    }

    @Override
    public void run(ParsedArguments parsedArguments) throws Exception {
    }

    public void run(Command command) {
        if (command != null) {
            String[] stringArray;
            System.out.format("Help for %s command%n", command.getCommandName());
            String string = "Description:\n" + command.getDescription() + "\n" + command.getDescriptionSupplement();
            System.out.println();
            System.out.println(this.blockWrite(string, 77, true));
            System.out.format("%nOption descriptions:%n", new Object[0]);
            StringBuilder stringBuilder = new StringBuilder();
            command.getFormattedOptionsHelp(stringBuilder);
            for (String string2 : stringArray = stringBuilder.toString().split("\n")) {
                System.out.format("   %s%n", string2);
            }
            System.out.format("%nExample commands: %n%s%n", command.getExamples());
        } else {
            ZebraCommandLineApp.printTopLevelHelp();
        }
    }

    @Override
    protected Range getExpectedArgRange() {
        return ZebraCommandConstants.ONE_ARG_RANGE;
    }

    @Override
    public String getHelpMessage() {
        return this.getDefaultHelpWithCustomUsage(String.format("usage: %s %s <command>%n", "java -jar ZSDK_API.jar", this.getCommandName()));
    }

    @Override
    public String getExamples() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Get the help for help\n");
        stringBuilder.append(String.format("\t%s %s %s", "java -jar ZSDK_API.jar", this.getCommandName(), this.getCommandName()));
        return stringBuilder.toString();
    }
}

