/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.certificate;

import com.zebra.sdk.certificate.ZebraCertificateException;
import com.zebra.sdk.certificate.ZebraCertificateInfo;
import com.zebra.sdk.certificate.ZebraP12Info;
import com.zebra.sdk.certificate.internal.CertUtilitiesFactory;
import com.zebra.sdk.certificate.internal.CertUtilitiesI;
import com.zebra.sdk.util.internal.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class CertificateParser {
    private static final String PRIVATE_KEY_PATTERN = "(-----BEGIN( RSA)? PRIVATE KEY-----.*?-----END( RSA)? PRIVATE KEY-----)";
    private static final String CERTIFICATE_PATTERN = "(-----BEGIN CERTIFICATE-----.*?-----END CERTIFICATE-----)";
    private static final String PEM_PATTERN = "(-----BEGIN .*?-----.*?-----END .*?-----)";

    private CertificateParser() {
    }

    public static ZebraCertificateInfo parseCertificate(InputStream inputStream, String string, String string2) throws IOException, ZebraCertificateException, CertificateEncodingException, KeyStoreException {
        boolean bl;
        boolean bl2;
        byte[] byArray = null;
        byArray = new byte[inputStream.available()];
        IOUtils.readFully((InputStream)inputStream, (byte[])byArray);
        byArray = CertificateParser.stripPkcs7OpenSSLHeader(byArray);
        String string3 = new String(byArray);
        ZebraCertificateInfo zebraCertificateInfo = new ZebraCertificateInfo();
        boolean bl3 = CertificateParser.parseAsPem(zebraCertificateInfo, string3);
        if (!(bl3 || (bl2 = CertificateParser.parseAsCertificate(byArray, zebraCertificateInfo)) || (bl = CertificateParser.parseAsDerPrivateKey(byArray, zebraCertificateInfo)))) {
            CertificateParser.parseAsP12(byArray, zebraCertificateInfo, string, string2);
        }
        return zebraCertificateInfo;
    }

    private static byte[] stripPkcs7OpenSSLHeader(byte[] byArray) {
        String string = "-----BEGIN PKCS7-----";
        String string2 = "-----END PKCS7-----";
        String string3 = new String(byArray);
        if (string3.contains(string)) {
            string3 = string3.replaceAll(string, "");
            string3 = string3.replaceAll(string2, "");
            return Base64.decode(string3.trim());
        }
        return byArray;
    }

    private static void parseAsP12(byte[] byArray, ZebraCertificateInfo zebraCertificateInfo, String string, String string2) throws ZebraCertificateException, CertificateEncodingException, KeyStoreException {
        ZebraP12Info zebraP12Info = new ZebraP12Info(new ByteArrayInputStream(byArray), string2);
        zebraCertificateInfo.clientCertificate = zebraP12Info.getCertificateContent();
        zebraCertificateInfo.privateKey = zebraP12Info.getEncryptedPrivateKeyContent(string2, string2);
        CertUtilitiesI certUtilitiesI = CertUtilitiesFactory.getCertUtilities();
        if (string == null) {
            string = zebraP12Info.getKeyStore().aliases().nextElement();
        }
        Certificate[] certificateArray = certUtilitiesI.getCertificateChain(string, zebraP12Info.getKeyStore());
        for (int i = 1; i < certificateArray.length; ++i) {
            byte[] byArray2 = certificateArray[i].getEncoded();
            zebraCertificateInfo.caCertificates.add(certUtilitiesI.convertDerCertToPemCert(byArray2));
        }
    }

    private static boolean parseAsDerPrivateKey(byte[] byArray, ZebraCertificateInfo zebraCertificateInfo) {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            StringWriter stringWriter = new StringWriter();
            CertUtilitiesFactory.getCertificateHelper().pemWriterHelper(privateKey, stringWriter);
            zebraCertificateInfo.privateKey = stringWriter.toString().replace("\r\n", "\n").replace("\n", "\r\n");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean parseAsCertificate(byte[] byArray, ZebraCertificateInfo zebraCertificateInfo) throws IOException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", CertUtilitiesFactory.getCertificateHelper().getCertificateProvider());
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(new ByteArrayInputStream(byArray));
            for (Certificate certificate : collection) {
                StringWriter stringWriter = new StringWriter();
                CertUtilitiesFactory.getCertificateHelper().pemWriterHelper(certificate, stringWriter);
                CertificateParser.addCertificate(zebraCertificateInfo, certificateFactory, stringWriter.toString().replace("\r\n", "\n").replace("\n", "\r\n"));
            }
            return true;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    private static boolean parseAsPem(ZebraCertificateInfo zebraCertificateInfo, String string) {
        if (string.contains("-----BEGIN")) {
            string = CertificateParser.stripExtraInfo(string);
            zebraCertificateInfo.privateKey = CertificateParser.getPrivateKeyFromPem(string);
            CertificateParser.processPemCertificates(zebraCertificateInfo, string);
            return true;
        }
        return false;
    }

    private static void processPemCertificates(ZebraCertificateInfo zebraCertificateInfo, String string) {
        Matcher matcher = CertificateParser.getMatcher(CERTIFICATE_PATTERN, string);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (matcher.find()) {
                String string2 = matcher.group(0).replace("\r\n", "\n").replace("\n", "\r\n");
                CertificateParser.addCertificate(zebraCertificateInfo, certificateFactory, string2);
            }
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
    }

    private static void addCertificate(ZebraCertificateInfo zebraCertificateInfo, CertificateFactory certificateFactory, String string) throws CertificateException {
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(string.getBytes()));
        if (x509Certificate.getBasicConstraints() == -1) {
            zebraCertificateInfo.clientCertificate = string;
        } else {
            zebraCertificateInfo.caCertificates.add(string);
        }
    }

    private static String getPrivateKeyFromPem(String string) {
        Matcher matcher = CertificateParser.getMatcher(PRIVATE_KEY_PATTERN, string);
        if (matcher.find()) {
            return matcher.group(0).replace("\r\n", "\n").replace("\n", "\r\n");
        }
        return null;
    }

    private static Matcher getMatcher(String string, String string2) {
        Pattern pattern = Pattern.compile(string, 40);
        Matcher matcher = pattern.matcher(string2);
        return matcher;
    }

    private static String stripExtraInfo(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Pattern pattern = Pattern.compile(PEM_PATTERN, 40);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(0);
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

