/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.settings;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.settings.internal.ConnectionUtil;
import com.zebra.sdk.settings.internal.JsonHelper;
import com.zebra.sdk.settings.internal.JsonValidator;
import com.zebra.sdk.settings.internal.SgdValidator;
import com.zebra.sdk.util.internal.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SettingsValues {
    private Map<String, String> getValuesUsingJson(List<String> list, Connection connection) throws ConnectionException, ZebraIllegalArgumentException {
        Map<String, String> map = null;
        byte[] byArray = JsonHelper.buildQuery(list);
        byte[] byArray2 = connection.sendAndWaitForValidResponse(byArray, connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData(), new JsonValidator());
        map = JsonHelper.parseGetResponse(byArray2);
        return map;
    }

    private Map<String, String> getValuesUsingSGD(List<String> list, Connection connection) throws ConnectionException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : list) {
            String string2 = "! U1 getvar \"" + string + "\"" + "\r\n";
            byte[] byArray = connection.sendAndWaitForValidResponse(string2.getBytes(), connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData(), new SgdValidator());
            String string3 = StringUtilities.stripQuotes(new String(byArray));
            if (string3.equals("?")) {
                string3 = null;
            }
            hashMap.put(string, string3);
        }
        return hashMap;
    }

    public Map<String, String> getValues(List<String> list, Connection connection, PrinterLanguage printerLanguage, LinkOsInformation linkOsInformation) throws ConnectionException, ZebraIllegalArgumentException {
        Connection connection2 = ConnectionUtil.selectConnection(connection);
        boolean bl = this.shouldUseJson(connection, printerLanguage, linkOsInformation);
        if (bl) {
            return this.getValuesUsingJson(list, connection2);
        }
        return this.getValuesUsingSGD(list, connection2);
    }

    private boolean shouldUseJson(Connection connection, PrinterLanguage printerLanguage, LinkOsInformation linkOsInformation) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if (linkOsInformation == null || linkOsInformation.getMajor() < 1) {
            return false;
        }
        boolean bl4 = bl3 = printerLanguage == PrinterLanguage.LINE_PRINT;
        if (connection instanceof MultichannelConnection) {
            bl2 = ((MultichannelConnection)connection).getStatusChannel().isConnected();
            bl = ((MultichannelConnection)connection).getPrintingChannel().isConnected();
        } else {
            bl2 = connection instanceof StatusConnection;
            bl = !(connection instanceof StatusConnection);
        }
        return bl2 || bl && false == bl3;
    }

    private Map<String, String> setValuesUsingJson(Map<String, String> map, Connection connection) throws ConnectionException, ZebraIllegalArgumentException {
        Map<String, String> map2 = null;
        byte[] byArray = JsonHelper.buildSetCommand(map);
        byte[] byArray2 = connection.sendAndWaitForValidResponse(byArray, connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData(), new JsonValidator());
        map2 = JsonHelper.parseGetResponse(byArray2);
        return map2;
    }

    private Map<String, String> setValuesUsingSGD(Map<String, String> map, Connection connection) throws ConnectionException {
        for (String string : map.keySet()) {
            String string2 = "! U1 setvar \"" + string + "\" \"" + map.get(string) + "\"" + "\r\n";
            connection.write(string2.getBytes());
        }
        return this.getValuesUsingSGD(new ArrayList<String>(map.keySet()), connection);
    }

    public Map<String, String> setValues(Map<String, String> map, Connection connection, PrinterLanguage printerLanguage, LinkOsInformation linkOsInformation) throws ConnectionException, ZebraIllegalArgumentException {
        Connection connection2 = ConnectionUtil.selectConnection(connection);
        boolean bl = this.shouldUseJson(connection, printerLanguage, linkOsInformation);
        if (bl) {
            return this.setValuesUsingJson(map, connection2);
        }
        return this.setValuesUsingSGD(map, connection2);
    }
}

