/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.PrinterObjectProperties;
import com.zebra.sdk.printer.internal.PrinterFilePropertiesCisdf;
import com.zebra.sdk.printer.operations.internal.PrinterOperationCaresAboutLinkOsVersion;
import com.zebra.sdk.util.internal.CisdfFileSender;
import com.zebra.sdk.util.internal.FileUtilities;
import com.zebra.sdk.util.internal.MultipartFileSender;
import com.zebra.sdk.util.internal.PrinterFileDescriptor;
import com.zebra.sdk.util.internal.PrinterFilePath;
import java.util.ArrayList;
import java.util.List;

public class FileStorer
extends PrinterOperationCaresAboutLinkOsVersion<List<PrinterObjectProperties>> {
    private static final long serialVersionUID = -7215787839779520344L;
    private List<PrinterFileDescriptor> fileDescriptors;

    public FileStorer(List<PrinterFileDescriptor> list, Connection connection, PrinterLanguage printerLanguage, LinkOsInformation linkOsInformation) {
        super(connection, printerLanguage, linkOsInformation);
        this.fileDescriptors = list;
    }

    @Override
    public List<PrinterObjectProperties> execute() throws ConnectionException {
        this.selectProperChannel();
        this.isOkToProceed();
        return this.storeFile();
    }

    private void isOkToProceed() throws ConnectionException {
        if (!(this.isLinkOs2_5_OrHigher() || !(this.connection instanceof StatusConnection) && this.connection.isConnected())) {
            throw new ConnectionException("Cannot store objects over status channel on this version of firmware");
        }
    }

    private List<PrinterObjectProperties> storeFile() throws ConnectionException {
        List<Object> list = new ArrayList();
        if (this.shouldSendMultipartForm()) {
            list = MultipartFileSender.send(this.connection, this.fileDescriptors);
        } else {
            CisdfFileSender.send(this.connection, this.fileDescriptors);
            list = this.createPrinterFilePropertiesFromFileDescriptors();
        }
        return list;
    }

    private List<PrinterObjectProperties> createPrinterFilePropertiesFromFileDescriptors() {
        ArrayList<PrinterObjectProperties> arrayList = new ArrayList<PrinterObjectProperties>();
        for (PrinterFileDescriptor printerFileDescriptor : this.fileDescriptors) {
            try {
                PrinterFilePath printerFilePath = FileUtilities.parseDriveAndExtension(printerFileDescriptor.getName());
                String string = printerFilePath.getDrive();
                String string2 = string.substring(0, 1) + ":";
                String string3 = printerFilePath.getFileName();
                String string4 = printerFilePath.getExtension().substring(1);
                long l = printerFileDescriptor.getFileSize();
                arrayList.add(new PrinterFilePropertiesCisdf(string2, string3, string4, l));
            }
            catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {}
        }
        return arrayList;
    }

    private boolean shouldSendMultipartForm() {
        return this.isLinkOs2_5_OrHigher() && (this.printerLanguage != PrinterLanguage.LINE_PRINT || this.connection instanceof StatusConnection);
    }
}

