/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.operations.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.operations.internal.PrinterOperationBase;
import com.zebra.sdk.settings.internal.JsonValidator;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ClockSetter
extends PrinterOperationBase<Void> {
    private static final long serialVersionUID = -8919634753534371273L;
    private String dateTime;
    DateTime formattedDateTime;

    public ClockSetter(String string, Connection connection, PrinterLanguage printerLanguage) {
        super(connection, printerLanguage);
        this.dateTime = string;
    }

    @Override
    public Void execute() throws ZebraIllegalArgumentException, ConnectionException {
        this.formattedDateTime = this.formatDateTime(this.dateTime);
        this.selectStatusChannelIfOpen();
        this.setClock();
        return null;
    }

    private void setClock() throws ZebraIllegalArgumentException, ConnectionException {
        if (this.shouldUseJson(this.connection, this.printerLanguage)) {
            if (this.formattedDateTime.date != null) {
                this.connection.sendAndWaitForValidResponse(("{}{\"rtc.date\":\"" + this.formattedDateTime.date + "\"}").getBytes(), this.connection.getMaxTimeoutForRead(), this.connection.getTimeToWaitForMoreData(), new JsonValidator());
            }
            if (this.formattedDateTime.time != null) {
                this.connection.sendAndWaitForValidResponse(("{}{\"rtc.time\":\"" + this.formattedDateTime.time + "\"}").getBytes(), this.connection.getMaxTimeoutForRead(), this.connection.getTimeToWaitForMoreData(), new JsonValidator());
            }
        } else {
            if (this.formattedDateTime.date != null) {
                SGD.SET("rtc.date", this.formattedDateTime.date, this.connection);
            }
            if (this.formattedDateTime.time != null) {
                SGD.SET("rtc.time", this.formattedDateTime.time, this.connection);
            }
        }
    }

    private DateTime formatDateTime(String string) throws ZebraIllegalArgumentException {
        String[] stringArray = this.splitDateTimeFormat(string);
        String string2 = null;
        String string3 = null;
        for (String string4 : stringArray) {
            ParsePosition parsePosition;
            SimpleDateFormat simpleDateFormat;
            if (string4.contains("-")) {
                simpleDateFormat = new SimpleDateFormat("MM-dd-yy");
                simpleDateFormat.setLenient(false);
                parsePosition = new ParsePosition(0);
                Date date = simpleDateFormat.parse(string4, parsePosition);
                if (parsePosition != null && parsePosition.getIndex() != string4.length()) {
                    throw new ZebraIllegalArgumentException("Invalid Date: \"" + string4 + "\"");
                }
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("MM-dd-yyyy");
                string2 = simpleDateFormat2.format(date);
                continue;
            }
            if (!string4.contains(":")) continue;
            simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            simpleDateFormat.setLenient(false);
            parsePosition = new ParsePosition(0);
            simpleDateFormat.parse(string4, parsePosition);
            if (parsePosition != null && parsePosition.getIndex() != string4.length()) {
                throw new ZebraIllegalArgumentException("Invalid Time: \"" + string4 + "\"");
            }
            string3 = string4;
        }
        return new DateTime(string2, string3);
    }

    private Date get100YearStartDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 1998);
        calendar.set(2, 1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private String[] splitDateTimeFormat(String string) throws ZebraIllegalArgumentException {
        String[] stringArray = string.split(" ");
        if (!string.contains("-") && !string.contains(":")) {
            throw new ZebraIllegalArgumentException("Invalid Date/Time: \"" + string + "\"");
        }
        return stringArray;
    }

    private boolean shouldUseJson(Connection connection, PrinterLanguage printerLanguage) {
        boolean bl = printerLanguage == PrinterLanguage.LINE_PRINT;
        boolean bl2 = connection instanceof StatusConnection;
        boolean bl3 = !(connection instanceof StatusConnection);
        return bl2 || bl3 && false == bl;
    }

    class DateTime {
        public String date;
        public String time;

        public DateTime(String string, String string2) {
            this.date = string;
            this.time = string2;
        }
    }
}

