/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.device.FileUtil;
import com.zebra.sdk.device.ProgressMonitor;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.graphics.ZebraImageI;
import com.zebra.sdk.printer.FieldDescriptionData;
import com.zebra.sdk.printer.FormatUtil;
import com.zebra.sdk.printer.GraphicsUtil;
import com.zebra.sdk.printer.PrinterObjectProperties;
import com.zebra.sdk.printer.ToolsUtil;
import com.zebra.sdk.printer.ZebraPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

public abstract class ZebraPrinterA
implements ZebraPrinter {
    protected Connection connection = null;
    protected FileUtil fileUtil = null;
    protected FormatUtil formatUtil = null;
    protected GraphicsUtil graphicsUtil = null;
    protected ToolsUtil toolsUtil = null;

    protected ZebraPrinterA(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void sendFileContents(String string) throws ConnectionException {
        this.fileUtil.sendFileContents(string);
    }

    @Override
    public void sendFileContents(String string, ProgressMonitor progressMonitor) throws ConnectionException {
        this.fileUtil.sendFileContents(string, progressMonitor);
    }

    @Override
    public String[] retrieveFileNames() throws ConnectionException, ZebraIllegalArgumentException {
        return this.fileUtil.retrieveFileNames();
    }

    @Override
    public String[] retrieveFileNames(String[] stringArray) throws ConnectionException, ZebraIllegalArgumentException {
        return this.fileUtil.retrieveFileNames(stringArray);
    }

    @Override
    public void printImage(String string, int n, int n2) throws ConnectionException, IOException {
        this.graphicsUtil.printImage(string, n, n2);
    }

    @Override
    public void printImage(String string, int n, int n2, int n3, int n4, boolean bl) throws ConnectionException, IOException {
        this.graphicsUtil.printImage(string, n, n2, n3, n4, bl);
    }

    @Override
    public void printImage(ZebraImageI zebraImageI, int n, int n2, int n3, int n4, boolean bl) throws ConnectionException {
        this.graphicsUtil.printImage(zebraImageI, n, n2, n3, n4, bl);
    }

    @Override
    public void storeImage(String string, ZebraImageI zebraImageI, int n, int n2) throws ConnectionException, ZebraIllegalArgumentException {
        this.graphicsUtil.storeImage(string, zebraImageI, n, n2);
    }

    @Override
    public void storeImage(String string, String string2, int n, int n2) throws ConnectionException, ZebraIllegalArgumentException, IOException {
        this.graphicsUtil.storeImage(string, string2, n, n2);
    }

    @Override
    public byte[] retrieveFormatFromPrinter(String string) throws ConnectionException {
        return this.formatUtil.retrieveFormatFromPrinter(string);
    }

    @Override
    public void retrieveFormatFromPrinter(OutputStream outputStream, String string) throws ConnectionException {
        this.formatUtil.retrieveFormatFromPrinter(outputStream, string);
    }

    @Override
    public void printStoredFormat(String string, String[] stringArray) throws ConnectionException {
        this.formatUtil.printStoredFormat(string, stringArray);
    }

    @Override
    public void printStoredFormat(String string, String[] stringArray, String string2) throws ConnectionException, UnsupportedEncodingException {
        this.formatUtil.printStoredFormat(string, stringArray, string2);
    }

    @Override
    public void printStoredFormat(String string, Map<Integer, String> map) throws ConnectionException {
        this.formatUtil.printStoredFormat(string, map);
    }

    @Override
    public void printStoredFormat(String string, Map<Integer, String> map, String string2) throws ConnectionException, UnsupportedEncodingException {
        this.formatUtil.printStoredFormat(string, map, string2);
    }

    @Override
    public FieldDescriptionData[] getVariableFields(String string) {
        return this.formatUtil.getVariableFields(string);
    }

    @Override
    public void calibrate() throws ConnectionException {
        this.toolsUtil.calibrate();
    }

    @Override
    public void restoreDefaults() throws ConnectionException {
        this.toolsUtil.restoreDefaults();
    }

    @Override
    public void printConfigurationLabel() throws ConnectionException {
        this.toolsUtil.printConfigurationLabel();
    }

    @Override
    public void sendCommand(String string) throws ConnectionException {
        this.toolsUtil.sendCommand(string);
    }

    @Override
    public void sendCommand(String string, String string2) throws ConnectionException, UnsupportedEncodingException {
        this.toolsUtil.sendCommand(string, string2);
    }

    @Override
    public void reset() throws ConnectionException {
        this.toolsUtil.reset();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public List<PrinterObjectProperties> retrieveObjectsProperties() throws ConnectionException, ZebraIllegalArgumentException {
        return this.fileUtil.retrieveObjectsProperties();
    }
}

