/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.MultichannelConnection;
import com.zebra.sdk.comm.StatusConnection;
import com.zebra.sdk.device.ZebraIllegalArgumentException;
import com.zebra.sdk.printer.LinkOsInformation;
import com.zebra.sdk.printer.PrinterLanguage;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.ZebraPrinter;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.ZebraPrinterLinkOs;
import com.zebra.sdk.printer.discovery.DiscoveredPrinterNetwork;
import com.zebra.sdk.printer.discovery.DiscoveryPacketDecodeException;
import com.zebra.sdk.printer.discovery.internal.DiscoveredPrinterNetworkFactory;
import com.zebra.sdk.printer.internal.ZebraPrinterLinkOsImpl;
import com.zebra.sdk.printer.internal.ZebraPrinterZpl;
import com.zebra.sdk.settings.internal.JsonHelper;
import com.zebra.sdk.settings.internal.JsonValidator;
import com.zebra.sdk.util.internal.Base64;
import com.zebra.sdk.util.internal.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class LinkOsPrinterCreatorSgdOrJson {
    private LinkOsInformation linkosInfo;
    private PrinterLanguage language;

    protected LinkOsPrinterCreatorSgdOrJson(PrinterLanguage printerLanguage) {
        this(new LinkOsInformation(-1, -1), printerLanguage);
    }

    protected LinkOsPrinterCreatorSgdOrJson(LinkOsInformation linkOsInformation) {
        this(linkOsInformation, null);
    }

    protected LinkOsPrinterCreatorSgdOrJson(LinkOsInformation linkOsInformation, PrinterLanguage printerLanguage) {
        this.linkosInfo = linkOsInformation;
        this.language = printerLanguage;
    }

    public ZebraPrinterLinkOs create(Connection connection) throws ConnectionException {
        return this.create(new ZebraPrinterZpl(connection));
    }

    public ZebraPrinterLinkOs create(ZebraPrinter zebraPrinter) throws ConnectionException {
        ZebraPrinterLinkOs zebraPrinterLinkOs = null;
        try {
            Connection connection = zebraPrinter.getConnection();
            zebraPrinterLinkOs = connection instanceof MultichannelConnection ? this.createLinkOsPrinterFromMultiChannelConnection(zebraPrinter) : this.createLinkOsPrinterFromStandardConnection(zebraPrinter);
        }
        catch (RuntimeException runtimeException) {
        }
        catch (ZebraPrinterLanguageUnknownException zebraPrinterLanguageUnknownException) {
            // empty catch block
        }
        return zebraPrinterLinkOs;
    }

    private ZebraPrinterLinkOs createLinkOsPrinterFromMultiChannelConnection(ZebraPrinter zebraPrinter) throws RuntimeException, ConnectionException, ZebraPrinterLanguageUnknownException {
        MultichannelConnection multichannelConnection = (MultichannelConnection)zebraPrinter.getConnection();
        this.language = this.obtainLanguage(multichannelConnection);
        this.linkosInfo = this.obtainVersion(multichannelConnection);
        return new ZebraPrinterLinkOsImpl(zebraPrinter, this.linkosInfo, this.language);
    }

    private ZebraPrinterLinkOs createLinkOsPrinterFromStandardConnection(ZebraPrinter zebraPrinter) throws RuntimeException, ConnectionException, ZebraPrinterLanguageUnknownException {
        this.language = this.obtainLanguage(zebraPrinter.getConnection());
        this.linkosInfo = this.obtainVersion(zebraPrinter.getConnection());
        return new ZebraPrinterLinkOsImpl(zebraPrinter, this.linkosInfo, this.language);
    }

    private LinkOsInformation obtainVersion(Connection connection) throws RuntimeException, ConnectionException {
        return this.shouldQueryPrinter() ? this.queryVersionNumber(connection) : this.linkosInfo;
    }

    private boolean shouldQueryPrinter() {
        return this.linkosInfo.getMajor() < 0;
    }

    private PrinterLanguage obtainLanguage(Connection connection) throws RuntimeException, ConnectionException, ZebraPrinterLanguageUnknownException {
        return this.shouldQueryLanguage() ? this.queryPrinterLanguage(connection) : this.language;
    }

    private boolean shouldQueryLanguage() {
        return this.language == null;
    }

    private PrinterLanguage queryPrinterLanguage(Connection connection) throws RuntimeException, ConnectionException, ZebraPrinterLanguageUnknownException {
        if (connection instanceof MultichannelConnection) {
            MultichannelConnection multichannelConnection = (MultichannelConnection)connection;
            if (multichannelConnection.getStatusChannel().isConnected()) {
                return this.getLanguageViaJson(multichannelConnection.getStatusChannel());
            }
        } else if (connection instanceof StatusConnection) {
            return this.getLanguageViaJson(connection);
        }
        return this.getLanguageViaSgd(connection);
    }

    private PrinterLanguage getLanguageViaSgd(Connection connection) throws ConnectionException, ZebraPrinterLanguageUnknownException {
        String string = SGD.GET("device.languages", connection);
        return PrinterLanguage.getLanguage(string);
    }

    private LinkOsInformation queryVersionNumber(Connection connection) throws RuntimeException, ConnectionException {
        MultichannelConnection multichannelConnection;
        Map<String, String> map = null;
        map = connection instanceof MultichannelConnection ? ((multichannelConnection = (MultichannelConnection)connection).getStatusChannel().isConnected() ? this.getDiscoMapViaJson(multichannelConnection.getStatusChannel()) : this.queryVersionInfoOverSingleChannel(multichannelConnection.getPrintingChannel())) : this.queryVersionInfoOverSingleChannel(connection);
        return this.getLinkOsVersionFromDiscoMap(map);
    }

    private PrinterLanguage getLanguageViaJson(Connection connection) throws ConnectionException, ZebraPrinterLanguageUnknownException {
        byte[] byArray = connection.sendAndWaitForValidResponse("{}{\"device.languages\":null}".getBytes(), connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData(), new JsonValidator());
        try {
            Map<String, String> map = StringUtilities.convertKeyValueJsonToMap(byArray);
            return PrinterLanguage.getLanguage(map.get("device.languages"));
        }
        catch (IOException iOException) {
            throw new ZebraPrinterLanguageUnknownException("Zebra printer language could not be determined for " + connection.toString());
        }
    }

    private LinkOsInformation getLinkOsVersionFromDiscoMap(Map<String, String> map) {
        return new LinkOsInformation(StringUtilities.getIntValueForKey(map, "LINK_OS_MAJOR_VER"), StringUtilities.getIntValueForKey(map, "LINK_OS_MINOR_VER"));
    }

    private Map<String, String> queryVersionInfoOverSingleChannel(Connection connection) throws ConnectionException {
        Map<String, String> map = this.language == PrinterLanguage.ZPL ? this.getDiscoMapViaJson(connection) : (connection instanceof StatusConnection ? this.getDiscoMapViaJson(connection) : this.getDiscoMapViaSgd(connection));
        return map;
    }

    private Map<String, String> getDiscoMapViaSgd(Connection connection) throws ConnectionException {
        try {
            String string = SGD.GET("ip.discovery_packet", connection);
            byte[] byArray = Base64.decode(string.split(":")[0]);
            return this.parseDiscoPacket(byArray);
        }
        catch (DiscoveryPacketDecodeException discoveryPacketDecodeException) {
            return null;
        }
    }

    private Map<String, String> getDiscoMapViaJson(Connection connection) throws ConnectionException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ip.discovery_packet");
        byte[] byArray = JsonHelper.buildQuery(arrayList);
        try {
            byte[] byArray2 = connection.sendAndWaitForValidResponse(byArray, connection.getMaxTimeoutForRead(), connection.getTimeToWaitForMoreData(), new JsonValidator());
            Map<String, String> map = JsonHelper.parseGetResponse(byArray2);
            byte[] byArray3 = Base64.decode(map.get("ip.discovery_packet").split(":")[0]);
            return this.parseDiscoPacket(byArray3);
        }
        catch (DiscoveryPacketDecodeException discoveryPacketDecodeException) {
        }
        catch (ZebraIllegalArgumentException zebraIllegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private Map<String, String> parseDiscoPacket(byte[] byArray) throws DiscoveryPacketDecodeException {
        Map<String, String> map = null;
        DiscoveredPrinterNetwork discoveredPrinterNetwork = DiscoveredPrinterNetworkFactory.getDiscoveredPrinterNetwork(byArray);
        if (DiscoveredPrinterNetworkFactory.isLinkOsPrinter(discoveredPrinterNetwork)) {
            map = discoveredPrinterNetwork.getDiscoveryDataMap();
        }
        return map;
    }
}

