/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.printer.FieldDescriptionData;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.internal.FormatUtilA;
import com.zebra.sdk.util.internal.StringUtilities;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;

public class FormatUtilCpcl
extends FormatUtilA {
    public FormatUtilCpcl(Connection connection) {
        super(connection);
    }

    @Override
    public byte[] retrieveFormatFromPrinter(String string) throws ConnectionException {
        return SGD.DO("file.type", string, this.printerConnection).getBytes();
    }

    @Override
    public void retrieveFormatFromPrinter(OutputStream outputStream, String string) throws ConnectionException {
        SGD.DO(outputStream, "file.type", string, this.printerConnection);
    }

    @Override
    public void printStoredFormat(String string, Map<Integer, String> map) throws ConnectionException {
        try {
            this.printStoredFormat(string, map, System.getProperty("file.encoding"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    @Override
    public void printStoredFormat(String string, Map<Integer, String> map, String string2) throws ConnectionException, UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("! UF ");
        stringBuffer.append(string);
        stringBuffer.append("\r\n");
        Iterator<Integer> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(map.get(iterator.next()));
            stringBuffer.append("\r\n");
        }
        this.printerConnection.write(stringBuffer.toString().getBytes(string2));
    }

    protected int countVariableFields(String string) {
        return StringUtilities.countSubstringOccurences(string, "\\\\");
    }

    @Override
    public FieldDescriptionData[] getVariableFields(String string) {
        FieldDescriptionData[] fieldDescriptionDataArray = new FieldDescriptionData[this.countVariableFields(string)];
        for (int i = 0; i < fieldDescriptionDataArray.length; ++i) {
            fieldDescriptionDataArray[i] = new FieldDescriptionData(i + 1, null);
        }
        return fieldDescriptionDataArray;
    }
}

