/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery;

import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.printer.discovery.DiscoveryHandler;
import com.zebra.sdk.printer.discovery.internal.DirectedBroadcast;
import com.zebra.sdk.printer.discovery.internal.FindPrinters;
import com.zebra.sdk.printer.discovery.internal.LocalBroadcast;
import com.zebra.sdk.printer.discovery.internal.MulticastBroadcast;
import com.zebra.sdk.printer.discovery.internal.PrinterNameSearch;
import com.zebra.sdk.printer.discovery.internal.SubnetSearch;
import java.util.List;

public class NetworkDiscoverer {
    private NetworkDiscoverer() {
    }

    public static void subnetSearch(DiscoveryHandler discoveryHandler, String string) throws DiscoveryException {
        SubnetSearch subnetSearch = new SubnetSearch(string);
        subnetSearch.doBroadcast(discoveryHandler);
    }

    public static void subnetSearch(DiscoveryHandler discoveryHandler, String string, int n) throws DiscoveryException {
        SubnetSearch subnetSearch = new SubnetSearch(string, n);
        subnetSearch.doBroadcast(discoveryHandler);
    }

    public static void directedBroadcast(DiscoveryHandler discoveryHandler, String string) throws DiscoveryException {
        DirectedBroadcast directedBroadcast = new DirectedBroadcast(string);
        directedBroadcast.doBroadcast(discoveryHandler);
    }

    public static void directedBroadcast(DiscoveryHandler discoveryHandler, String string, int n) throws DiscoveryException {
        DirectedBroadcast directedBroadcast = new DirectedBroadcast(string, n);
        directedBroadcast.doBroadcast(discoveryHandler);
    }

    public static void localBroadcast(DiscoveryHandler discoveryHandler) throws DiscoveryException {
        LocalBroadcast localBroadcast = new LocalBroadcast();
        localBroadcast.doBroadcast(discoveryHandler);
    }

    public static void localBroadcast(DiscoveryHandler discoveryHandler, int n) throws DiscoveryException {
        LocalBroadcast localBroadcast = new LocalBroadcast(n);
        localBroadcast.doBroadcast(discoveryHandler);
    }

    public static void multicast(DiscoveryHandler discoveryHandler, int n) throws DiscoveryException {
        MulticastBroadcast multicastBroadcast = new MulticastBroadcast(n);
        multicastBroadcast.doBroadcast(discoveryHandler);
    }

    public static void multicast(DiscoveryHandler discoveryHandler, int n, int n2) throws DiscoveryException {
        MulticastBroadcast multicastBroadcast = new MulticastBroadcast(n, n2);
        multicastBroadcast.doBroadcast(discoveryHandler);
    }

    public static void findPrinters(DiscoveryHandler discoveryHandler) throws DiscoveryException {
        FindPrinters findPrinters = new FindPrinters();
        findPrinters.doBroadcast(discoveryHandler);
    }

    public static void findPrinters(DiscoveryHandler discoveryHandler, List<String> list) throws DiscoveryException {
        PrinterNameSearch printerNameSearch = new PrinterNameSearch(discoveryHandler, list);
        printerNameSearch.doBroadcast(discoveryHandler);
    }

    public static void findPrinters(DiscoveryHandler discoveryHandler, List<String> list, int n) throws DiscoveryException {
        PrinterNameSearch printerNameSearch = new PrinterNameSearch(discoveryHandler, list, n);
        printerNameSearch.doBroadcast(discoveryHandler);
    }
}

