/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.graphics.internal;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class GrfToPngConverterDesktop {
    public static byte[] grfToPng(InputStream inputStream, int n, int n2) throws IOException {
        BufferedImage bufferedImage = GrfToPngConverterDesktop.getImage(inputStream, n, n2);
        return GrfToPngConverterDesktop.imageToByteArray(bufferedImage);
    }

    private static BufferedImage getImage(InputStream inputStream, int n, int n2) throws IOException {
        int n3 = 0;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 12);
        byte by = (byte)inputStream.read();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                boolean bl = GrfToPngConverterDesktop.getBit(by, n3);
                if (++n3 > 7) {
                    n3 = 0;
                    by = (byte)inputStream.read();
                }
                graphics2D.setColor(bl ? Color.BLACK : Color.WHITE);
                graphics2D.fillRect(j, i, 1, 1);
            }
        }
        return bufferedImage;
    }

    private static boolean getBit(byte by, int n) {
        int n2 = 1 << 7 - n;
        return (by & (byte)n2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] imageToByteArray(BufferedImage bufferedImage) {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byArray;
    }
}

